/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.logreceiver.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonSetter;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.Nulls;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.palantir.conjure.java.lib.internal.ConjureCollections;
import shadow.palantir.driver.com.palantir.logreceiver.api.WrappedTelemetry;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
public final class WrappedTelemetryBatch {
    private final List<WrappedTelemetry> logs;
    private int memoizedHashCode;

    private WrappedTelemetryBatch(List<WrappedTelemetry> logs) {
        WrappedTelemetryBatch.validateFields(logs);
        this.logs = Collections.unmodifiableList(logs);
    }

    @JsonProperty(value="logs")
    public List<WrappedTelemetry> getLogs() {
        return this.logs;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof WrappedTelemetryBatch && this.equalTo((WrappedTelemetryBatch)other);
    }

    private boolean equalTo(WrappedTelemetryBatch other) {
        if (this.memoizedHashCode != 0 && other.memoizedHashCode != 0 && this.memoizedHashCode != other.memoizedHashCode) {
            return false;
        }
        return this.logs.equals(other.logs);
    }

    public int hashCode() {
        int result = this.memoizedHashCode;
        if (result == 0) {
            this.memoizedHashCode = result = this.logs.hashCode();
        }
        return result;
    }

    public String toString() {
        return "WrappedTelemetryBatch{logs: " + this.logs + "}";
    }

    public static WrappedTelemetryBatch of(List<WrappedTelemetry> logs) {
        return WrappedTelemetryBatch.builder().logs(logs).build();
    }

    private static void validateFields(List<WrappedTelemetry> logs) {
        List<String> missingFields = null;
        if ((missingFields = WrappedTelemetryBatch.addFieldIfMissing(missingFields, logs, "logs")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        boolean _buildInvoked;
        private List<WrappedTelemetry> logs = new ArrayList<WrappedTelemetry>();

        private Builder() {
        }

        public Builder from(WrappedTelemetryBatch other) {
            this.checkNotBuilt();
            this.logs(other.getLogs());
            return this;
        }

        @JsonSetter(value="logs", nulls=Nulls.SKIP)
        public Builder logs(@Nonnull Iterable<WrappedTelemetry> logs) {
            this.checkNotBuilt();
            this.logs = ConjureCollections.newArrayList(Preconditions.checkNotNull(logs, "logs cannot be null"));
            return this;
        }

        public Builder addAllLogs(@Nonnull Iterable<WrappedTelemetry> logs) {
            this.checkNotBuilt();
            ConjureCollections.addAll(this.logs, Preconditions.checkNotNull(logs, "logs cannot be null"));
            return this;
        }

        public Builder logs(WrappedTelemetry logs) {
            this.checkNotBuilt();
            this.logs.add(logs);
            return this;
        }

        public WrappedTelemetryBatch build() {
            this.checkNotBuilt();
            this._buildInvoked = true;
            return new WrappedTelemetryBatch(this.logs);
        }

        private void checkNotBuilt() {
            Preconditions.checkState(!this._buildInvoked, "Build has already been called");
        }
    }
}

