/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.nylon.threads;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class VirtualThreads {
    private static final SafeLogger log = SafeLoggerFactory.get(VirtualThreads.class);
    private static final Optional<VirtualThreadSupport> VIRTUAL_THREAD_SUPPORT = VirtualThreads.maybeInitialize();

    public static boolean isVirtual(Thread thread) {
        return VIRTUAL_THREAD_SUPPORT.isPresent() && VIRTUAL_THREAD_SUPPORT.get().isVirtual(thread);
    }

    public static Optional<VirtualThreadSupport> get() {
        return VIRTUAL_THREAD_SUPPORT;
    }

    private static Optional<VirtualThreadSupport> maybeInitialize() {
        int featureVersion = Runtime.version().feature();
        if (featureVersion < 21) {
            if (log.isDebugEnabled()) {
                log.debug("Virtual threads are not available prior to jdk21", SafeArg.of("currentVersion", featureVersion));
            }
            return Optional.empty();
        }
        try {
            return Optional.of(new ReflectiveVirtualThreadSupport());
        }
        catch (Throwable t) {
            log.warn("Virtual thread support is not available", t);
            return Optional.empty();
        }
    }

    private VirtualThreads() {
    }

    private static final class ReflectiveVirtualThreadSupport
    implements VirtualThreadSupport {
        private static final MethodType THREAD_IS_VIRTUAL_TYPE = MethodType.methodType(Boolean.TYPE);
        private final MethodHandle threadIsVirtual;
        private final MethodHandle threadOfVirtual;
        private final MethodHandle ofVirtualFactory;
        private final MethodHandle ofVirtualNameString;
        private final MethodHandle ofVirtualNameStringLong;
        private final MethodHandle ofVirtualInheritInheritableThreadLocals;
        private final MethodHandle ofVirtualUncaughtExceptionHandler;
        private final MethodHandle ofVirtualUnstarted;
        private final MethodHandle ofVirtualStart;
        private final MethodHandle executorsNewThreadPerTaskExecutor;

        ReflectiveVirtualThreadSupport() throws ReflectiveOperationException {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            this.threadIsVirtual = lookup.findVirtual(Thread.class, "isVirtual", THREAD_IS_VIRTUAL_TYPE);
            Class<?> ofVirtual = lookup.findClass("java.lang.Thread$Builder$OfVirtual");
            MethodType threadOfVirtualType = MethodType.methodType(ofVirtual);
            this.threadOfVirtual = lookup.findStatic(Thread.class, "ofVirtual", threadOfVirtualType);
            MethodType ofVirtualFactoryType = MethodType.methodType(ThreadFactory.class);
            this.ofVirtualFactory = lookup.findVirtual(ofVirtual, "factory", ofVirtualFactoryType);
            MethodType ofVirtualNameStringType = MethodType.methodType(ofVirtual, String.class);
            this.ofVirtualNameString = lookup.findVirtual(ofVirtual, "name", ofVirtualNameStringType);
            MethodType ofVirtualNameStringLongType = MethodType.methodType(ofVirtual, String.class, Long.TYPE);
            this.ofVirtualNameStringLong = lookup.findVirtual(ofVirtual, "name", ofVirtualNameStringLongType);
            MethodType inheritInheritableThreadLocalsType = MethodType.methodType(ofVirtual, Boolean.TYPE);
            this.ofVirtualInheritInheritableThreadLocals = lookup.findVirtual(ofVirtual, "inheritInheritableThreadLocals", inheritInheritableThreadLocalsType);
            MethodType uncaughtExceptionHandlerType = MethodType.methodType(ofVirtual, Thread.UncaughtExceptionHandler.class);
            this.ofVirtualUncaughtExceptionHandler = lookup.findVirtual(ofVirtual, "uncaughtExceptionHandler", uncaughtExceptionHandlerType);
            MethodType ofVirtualThreadCreators = MethodType.methodType(Thread.class, Runnable.class);
            this.ofVirtualUnstarted = lookup.findVirtual(ofVirtual, "unstarted", ofVirtualThreadCreators);
            this.ofVirtualStart = lookup.findVirtual(ofVirtual, "start", ofVirtualThreadCreators);
            MethodType executorsNewThreadPerTaskExecutorType = MethodType.methodType(ExecutorService.class, ThreadFactory.class);
            this.executorsNewThreadPerTaskExecutor = lookup.findStatic(Executors.class, "newThreadPerTaskExecutor", executorsNewThreadPerTaskExecutorType);
        }

        @Override
        public boolean isVirtual(Thread thread) {
            try {
                return this.threadIsVirtual.invokeExact(thread);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new SafeRuntimeException("failed to invoke 'thread.isVirtual()'", t, new Arg[0]);
            }
        }

        @Override
        public ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
            try {
                return this.executorsNewThreadPerTaskExecutor.invoke(threadFactory);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new SafeRuntimeException("failed to invoke 'Executors.newThreadPerTaskExecutor'", t, new Arg[0]);
            }
        }

        @Override
        public VirtualThreadSupport.VirtualThreadBuilder ofVirtual() {
            try {
                return new ReflectiveVirtualThreadBuilder(this.threadOfVirtual.invokeWithArguments(new Object[0]));
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new SafeRuntimeException("failed to invoke 'Thread.ofVirtual()'", t, new Arg[0]);
            }
        }

        private final class ReflectiveVirtualThreadBuilder
        implements VirtualThreadSupport.VirtualThreadBuilder {
            private final Object ofVirtualDelegate;

            ReflectiveVirtualThreadBuilder(Object ofVirtualDelegate) {
                this.ofVirtualDelegate = ofVirtualDelegate;
            }

            @Override
            public VirtualThreadSupport.VirtualThreadBuilder name(String name) {
                try {
                    ReflectiveVirtualThreadSupport.this.ofVirtualNameString.invoke(this.ofVirtualDelegate, name);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new SafeRuntimeException("failed to invoke 'OfVirtual.name'", t, new Arg[0]);
                }
                return this;
            }

            @Override
            public VirtualThreadSupport.VirtualThreadBuilder name(String prefix, long start) {
                try {
                    ReflectiveVirtualThreadSupport.this.ofVirtualNameStringLong.invoke(this.ofVirtualDelegate, prefix, start);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new SafeRuntimeException("failed to invoke 'OfVirtual.name'", t, new Arg[0]);
                }
                return this;
            }

            @Override
            public VirtualThreadSupport.VirtualThreadBuilder inheritInheritableThreadLocals(boolean inherit) {
                try {
                    ReflectiveVirtualThreadSupport.this.ofVirtualInheritInheritableThreadLocals.invoke(this.ofVirtualDelegate, inherit);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new SafeRuntimeException("failed to invoke 'OfVirtual.inheritInheritableThreadLocals'", t, new Arg[0]);
                }
                return this;
            }

            @Override
            public VirtualThreadSupport.VirtualThreadBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler ueh) {
                try {
                    ReflectiveVirtualThreadSupport.this.ofVirtualUncaughtExceptionHandler.invoke(this.ofVirtualDelegate, ueh);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new SafeRuntimeException("failed to invoke 'OfVirtual.uncaughtExceptionHandler'", t, new Arg[0]);
                }
                return this;
            }

            @Override
            public Thread unstarted(Runnable task) {
                try {
                    return ReflectiveVirtualThreadSupport.this.ofVirtualUnstarted.invoke(this.ofVirtualDelegate, task);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new SafeRuntimeException("failed to invoke 'OfVirtual.unstarted'", t, new Arg[0]);
                }
            }

            @Override
            public Thread start(Runnable task) {
                try {
                    return ReflectiveVirtualThreadSupport.this.ofVirtualStart.invoke(this.ofVirtualDelegate, task);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new SafeRuntimeException("failed to invoke 'OfVirtual.start'", t, new Arg[0]);
                }
            }

            @Override
            public ThreadFactory factory() {
                try {
                    return ReflectiveVirtualThreadSupport.this.ofVirtualFactory.invoke(this.ofVirtualDelegate);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new SafeRuntimeException("failed to invoke 'OfVirtual.factory()'", t, new Arg[0]);
                }
            }
        }
    }

    public static interface VirtualThreadSupport {
        public boolean isVirtual(Thread var1);

        public ExecutorService newThreadPerTaskExecutor(ThreadFactory var1);

        public VirtualThreadBuilder ofVirtual();

        public static interface VirtualThreadBuilder {
            public VirtualThreadBuilder name(@Safe String var1);

            public VirtualThreadBuilder name(@Safe String var1, long var2);

            public VirtualThreadBuilder inheritInheritableThreadLocals(boolean var1);

            public VirtualThreadBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler var1);

            public Thread unstarted(Runnable var1);

            public Thread start(Runnable var1);

            public ThreadFactory factory();
        }
    }
}

