/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.random;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

public final class SafeThreadLocalRandom
extends Random {
    private static final Random INSTANCE = new SafeThreadLocalRandom();
    private boolean initialized = true;

    private SafeThreadLocalRandom() {
        super(0L);
    }

    public static Random get() {
        return INSTANCE;
    }

    @Override
    public void setSeed(long _seed) {
        if (this.initialized) {
            throw new UnsupportedOperationException("SafeThreadLocalRandom does not support setSeed");
        }
    }

    @Override
    protected int next(int _bits) {
        throw new UnsupportedOperationException("Internal Random#next(int) is not supported, this should only be thrown if an override is missing");
    }

    @Override
    public void nextBytes(byte[] bytes) {
        ThreadLocalRandom.current().nextBytes(bytes);
    }

    @Override
    public int nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    @Override
    public int nextInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    @Override
    public long nextLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @Override
    public float nextFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    @Override
    public double nextDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    @Override
    public double nextGaussian() {
        return ThreadLocalRandom.current().nextGaussian();
    }

    @Override
    public IntStream ints(long streamSize) {
        return ThreadLocalRandom.current().ints(streamSize);
    }

    @Override
    public IntStream ints() {
        return ThreadLocalRandom.current().ints();
    }

    @Override
    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        return ThreadLocalRandom.current().ints(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        return ThreadLocalRandom.current().ints(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long streamSize) {
        return ThreadLocalRandom.current().longs(streamSize);
    }

    @Override
    public LongStream longs() {
        return ThreadLocalRandom.current().longs();
    }

    @Override
    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        return ThreadLocalRandom.current().longs(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        return ThreadLocalRandom.current().longs(randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(long streamSize) {
        return ThreadLocalRandom.current().doubles(streamSize);
    }

    @Override
    public DoubleStream doubles() {
        return ThreadLocalRandom.current().doubles();
    }

    @Override
    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        return ThreadLocalRandom.current().doubles(streamSize, randomNumberOrigin, randomNumberBound);
    }

    @Override
    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        return ThreadLocalRandom.current().doubles(randomNumberOrigin, randomNumberBound);
    }

    public String toString() {
        return "SafeThreadLocalRandom{}";
    }
}

