/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.refreshable;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.util.concurrent.RateLimiter;
import shadow.palantir.driver.com.google.common.util.concurrent.ThreadFactoryBuilder;
import shadow.palantir.driver.com.palantir.refreshable.Disposable;
import shadow.palantir.driver.com.palantir.refreshable.Refreshable;
import shadow.palantir.driver.com.palantir.refreshable.SettableRefreshable;
import shadow.palantir.driver.javax.annotation.concurrent.GuardedBy;

final class DefaultRefreshable<@DoNotLog T>
implements SettableRefreshable<T> {
    private static final SafeLogger log = SafeLoggerFactory.get(DefaultRefreshable.class);
    private static final Cleaner REFRESHABLE_CLEANER = Cleaner.create(new ThreadFactoryBuilder().setNameFormat("DefaultRefreshable-Cleaner-%d").setDaemon(true).build());
    private static final int WARN_THRESHOLD = 1000;
    private final RateLimiter warningRateLimiter;
    private final Set<Consumer<? super T>> orderedSubscribers = Collections.synchronizedSet(new LinkedHashSet());
    private final RootSubscriberTracker rootSubscriberTracker;
    private volatile T current;
    private final Lock writeLock;
    private final Lock readLock;
    private final Optional<?> strongParentReference;

    DefaultRefreshable(T current) {
        this(current, Optional.empty(), new RootSubscriberTracker());
    }

    private DefaultRefreshable(T current, Optional<?> strongParentReference, RootSubscriberTracker tracker) {
        this.current = current;
        this.strongParentReference = strongParentReference;
        this.rootSubscriberTracker = tracker;
        this.warningRateLimiter = RateLimiter.create(10.0);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.writeLock = lock.writeLock();
        this.readLock = lock.readLock();
    }

    private <R> DefaultRefreshable<R> createChild(R initialChildValue) {
        Optional<DefaultRefreshable> parentReference = Optional.of(this);
        return new DefaultRefreshable<R>(initialChildValue, parentReference, this.rootSubscriberTracker);
    }

    @Override
    public void update(T value) {
        this.writeLock.lock();
        try {
            if (!Objects.equals(this.current, value)) {
                this.current = value;
                ImmutableList.copyOf(this.orderedSubscribers).forEach((Consumer<Consumer<T>>)((Consumer<Consumer>)subscriber -> subscriber.accept(value)));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public T current() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Disposable subscribe(Consumer<? super T> throwingSubscriber) {
        this.readLock.lock();
        try {
            SideEffectSubscriber<? super T> trackedSubscriber = this.rootSubscriberTracker.newSideEffectSubscriber(throwingSubscriber, this);
            Disposable disposable = this.subscribeToSelf(trackedSubscriber, true);
            SubscribeDisposable subscribeDisposable = new SubscribeDisposable(disposable, this.rootSubscriberTracker, trackedSubscriber);
            return subscribeDisposable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @GuardedBy(value="readLock")
    private Disposable subscribeToSelf(Consumer<? super T> subscriber, boolean updateSubscriber) {
        this.preSubscribeLogging();
        this.orderedSubscribers.add(subscriber);
        if (updateSubscriber) {
            subscriber.accept(this.current);
        }
        return new DefaultDisposable(this.orderedSubscribers, subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> Refreshable<R> map(Function<? super T, R> function) {
        this.readLock.lock();
        try {
            R initialChildValue = function.apply(this.current);
            DefaultRefreshable<R> child = this.createChild(initialChildValue);
            MapSubscriber<? super T, R> mapSubscriber = new MapSubscriber<T, R>(function, child);
            Disposable cleanUp = this.subscribeToSelf(mapSubscriber, false);
            REFRESHABLE_CLEANER.register(child, cleanUp::dispose);
            DefaultRefreshable<R> defaultRefreshable = child;
            return defaultRefreshable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void preSubscribeLogging() {
        if (log.isWarnEnabled()) {
            int subscribers = this.orderedSubscribers.size() + 1;
            if (subscribers > 1000 && this.warningRateLimiter.tryAcquire()) {
                log.warn("Refreshable {} has an excessive number of subscribers: {} and is likely leaking memory. The current warning threshold is {}.", SafeArg.of("refreshableIdentifier", System.identityHashCode(this)), SafeArg.of("numSubscribers", subscribers), SafeArg.of("warningThreshold", 1000), new SafeRuntimeException("location", new Arg[0]));
            } else if (log.isDebugEnabled()) {
                log.debug("Added a subscription to refreshable {} resulting in {} subscriptions", SafeArg.of("refreshableIdentifier", System.identityHashCode(this)), SafeArg.of("numSubscribers", subscribers));
            }
        }
    }

    @VisibleForTesting
    int subscribers() {
        return this.orderedSubscribers.size();
    }

    private static final class RootSubscriberTracker {
        private final Set<SideEffectSubscriber<?>> liveSubscribers = ConcurrentHashMap.newKeySet();

        private RootSubscriberTracker() {
        }

        <T> SideEffectSubscriber<? super T> newSideEffectSubscriber(Consumer<? super T> unsafeSubscriber, DefaultRefreshable<T> parent) {
            SideEffectSubscriber<? super T> freshSubscriber = new SideEffectSubscriber<T>(unsafeSubscriber, parent);
            this.liveSubscribers.add(freshSubscriber);
            return freshSubscriber;
        }

        void deleteReferenceTo(SideEffectSubscriber<?> subscriber) {
            this.liveSubscribers.remove(subscriber);
        }
    }

    private static final class MapSubscriber<@DoNotLog T, @DoNotLog R>
    implements Consumer<T> {
        private final WeakReference<DefaultRefreshable<R>> childRef;
        private final Function<T, R> function;

        private MapSubscriber(Function<T, R> function, DefaultRefreshable<R> child) {
            this.childRef = new WeakReference<DefaultRefreshable<R>>(child);
            this.function = function;
        }

        @Override
        public void accept(T value) {
            DefaultRefreshable child = (DefaultRefreshable)this.childRef.get();
            if (child != null) {
                try {
                    child.update(this.function.apply(value));
                }
                catch (RuntimeException e) {
                    log.error("Failed to update refreshable subscriber", e);
                }
            }
        }
    }

    private static class SideEffectSubscriber<@DoNotLog T>
    implements Consumer<T> {
        private final Consumer<T> unsafeSubscriber;
        private final Refreshable<?> strongParentReference;

        SideEffectSubscriber(Consumer<T> unsafeSubscriber, Refreshable<?> strongParentReference) {
            this.unsafeSubscriber = unsafeSubscriber;
            this.strongParentReference = strongParentReference;
        }

        @Override
        public void accept(T value) {
            try {
                this.unsafeSubscriber.accept(value);
            }
            catch (RuntimeException e) {
                log.error("Failed to update refreshable subscriber", e);
            }
        }
    }

    private static final class DefaultDisposable
    implements Disposable {
        private final WeakReference<Set<? extends Consumer<?>>> subscribersRef;
        private final WeakReference<Consumer<?>> subscriberRef;

        DefaultDisposable(Set<? extends Consumer<?>> subscribers, Consumer<?> subscriber) {
            this.subscribersRef = new WeakReference(subscribers);
            this.subscriberRef = new WeakReference(subscriber);
        }

        @Override
        public void dispose() {
            Set subscribers = (Set)this.subscribersRef.get();
            Consumer subscriber = (Consumer)this.subscriberRef.get();
            this.subscribersRef.clear();
            this.subscriberRef.clear();
            if (subscribers != null && subscriber != null) {
                subscribers.remove(subscriber);
            }
        }
    }

    private static final class SubscribeDisposable
    implements Disposable {
        private final Disposable delegate;
        private final RootSubscriberTracker rootSubscriberTracker;
        private final SideEffectSubscriber<?> trackedSubscriber;

        SubscribeDisposable(Disposable delegate, RootSubscriberTracker rootSubscriberTracker, SideEffectSubscriber<?> trackedSubscriber) {
            this.delegate = delegate;
            this.rootSubscriberTracker = rootSubscriberTracker;
            this.trackedSubscriber = trackedSubscriber;
        }

        @Override
        public void dispose() {
            this.delegate.dispose();
            this.rootSubscriberTracker.deleteReferenceTo(this.trackedSubscriber);
        }
    }
}

