/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.refreshable;

import java.util.function.Consumer;
import java.util.function.Function;
import shadow.palantir.driver.com.palantir.refreshable.Disposable;
import shadow.palantir.driver.com.palantir.refreshable.Refreshable;

final class ImmutableRefreshable<T>
implements Refreshable<T> {
    private final T value;

    ImmutableRefreshable(T value) {
        this.value = value;
    }

    @Override
    public T current() {
        return this.value;
    }

    @Override
    public Disposable subscribe(Consumer<? super T> consumer) {
        consumer.accept(this.value);
        return ImmutableRefreshableDisposable.INSTANCE;
    }

    @Override
    public <R> Refreshable<R> map(Function<? super T, R> function) {
        return new ImmutableRefreshable<R>(function.apply(this.value));
    }

    public String toString() {
        return "ImmutableRefreshable{" + this.value + "}";
    }

    private static enum ImmutableRefreshableDisposable implements Disposable
    {
        INSTANCE;


        @Override
        public void dispose() {
        }

        public String toString() {
            return "ImmutableRefreshableDisposable{}";
        }
    }
}

