/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalInt;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.sls.versions.OrderableSlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersionType;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OrderableSlsVersion", generator="Immutables")
@Immutable
final class ImmutableOrderableSlsVersion
extends OrderableSlsVersion {
    private final String value;
    private final int majorVersionNumber;
    private final int minorVersionNumber;
    private final int patchVersionNumber;
    @Nullable
    private final Integer firstSequenceVersionNumber;
    @Nullable
    private final Integer secondSequenceVersionNumber;
    private final SlsVersionType type;

    private ImmutableOrderableSlsVersion(String value, int majorVersionNumber, int minorVersionNumber, int patchVersionNumber, @Nullable Integer firstSequenceVersionNumber, @Nullable Integer secondSequenceVersionNumber, SlsVersionType type) {
        this.value = value;
        this.majorVersionNumber = majorVersionNumber;
        this.minorVersionNumber = minorVersionNumber;
        this.patchVersionNumber = patchVersionNumber;
        this.firstSequenceVersionNumber = firstSequenceVersionNumber;
        this.secondSequenceVersionNumber = secondSequenceVersionNumber;
        this.type = type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    @Override
    public int getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    @Override
    public int getPatchVersionNumber() {
        return this.patchVersionNumber;
    }

    @Override
    public OptionalInt firstSequenceVersionNumber() {
        return this.firstSequenceVersionNumber != null ? OptionalInt.of(this.firstSequenceVersionNumber) : OptionalInt.empty();
    }

    @Override
    public OptionalInt secondSequenceVersionNumber() {
        return this.secondSequenceVersionNumber != null ? OptionalInt.of(this.secondSequenceVersionNumber) : OptionalInt.empty();
    }

    @Override
    public SlsVersionType getType() {
        return this.type;
    }

    public final ImmutableOrderableSlsVersion withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(newValue, this.majorVersionNumber, this.minorVersionNumber, this.patchVersionNumber, this.firstSequenceVersionNumber, this.secondSequenceVersionNumber, this.type);
    }

    public final ImmutableOrderableSlsVersion withMajorVersionNumber(int value) {
        if (this.majorVersionNumber == value) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, value, this.minorVersionNumber, this.patchVersionNumber, this.firstSequenceVersionNumber, this.secondSequenceVersionNumber, this.type);
    }

    public final ImmutableOrderableSlsVersion withMinorVersionNumber(int value) {
        if (this.minorVersionNumber == value) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, value, this.patchVersionNumber, this.firstSequenceVersionNumber, this.secondSequenceVersionNumber, this.type);
    }

    public final ImmutableOrderableSlsVersion withPatchVersionNumber(int value) {
        if (this.patchVersionNumber == value) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, this.minorVersionNumber, value, this.firstSequenceVersionNumber, this.secondSequenceVersionNumber, this.type);
    }

    public final ImmutableOrderableSlsVersion withFirstSequenceVersionNumber(int value) {
        Integer newValue = value;
        if (Objects.equals(this.firstSequenceVersionNumber, newValue)) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, this.minorVersionNumber, this.patchVersionNumber, newValue, this.secondSequenceVersionNumber, this.type);
    }

    public final ImmutableOrderableSlsVersion withFirstSequenceVersionNumber(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.firstSequenceVersionNumber, value)) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, this.minorVersionNumber, this.patchVersionNumber, value, this.secondSequenceVersionNumber, this.type);
    }

    public final ImmutableOrderableSlsVersion withSecondSequenceVersionNumber(int value) {
        Integer newValue = value;
        if (Objects.equals(this.secondSequenceVersionNumber, newValue)) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, this.minorVersionNumber, this.patchVersionNumber, this.firstSequenceVersionNumber, newValue, this.type);
    }

    public final ImmutableOrderableSlsVersion withSecondSequenceVersionNumber(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.secondSequenceVersionNumber, value)) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, this.minorVersionNumber, this.patchVersionNumber, this.firstSequenceVersionNumber, value, this.type);
    }

    public final ImmutableOrderableSlsVersion withType(SlsVersionType value) {
        SlsVersionType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, this.minorVersionNumber, this.patchVersionNumber, this.firstSequenceVersionNumber, this.secondSequenceVersionNumber, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOrderableSlsVersion && this.equalTo(0, (ImmutableOrderableSlsVersion)another);
    }

    private boolean equalTo(int synthetic, ImmutableOrderableSlsVersion another) {
        return this.majorVersionNumber == another.majorVersionNumber && this.minorVersionNumber == another.minorVersionNumber && this.patchVersionNumber == another.patchVersionNumber && Objects.equals(this.firstSequenceVersionNumber, another.firstSequenceVersionNumber) && Objects.equals(this.secondSequenceVersionNumber, another.secondSequenceVersionNumber) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.majorVersionNumber;
        h += (h << 5) + this.minorVersionNumber;
        h += (h << 5) + this.patchVersionNumber;
        h += (h << 5) + Objects.hashCode(this.firstSequenceVersionNumber);
        h += (h << 5) + Objects.hashCode(this.secondSequenceVersionNumber);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public static OrderableSlsVersion copyOf(OrderableSlsVersion instance) {
        if (instance instanceof ImmutableOrderableSlsVersion) {
            return (ImmutableOrderableSlsVersion)instance;
        }
        return new OrderableSlsVersion.Builder().from(instance).build();
    }

    @Generated(from="OrderableSlsVersion", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_MAJOR_VERSION_NUMBER = 2L;
        private static final long INIT_BIT_MINOR_VERSION_NUMBER = 4L;
        private static final long INIT_BIT_PATCH_VERSION_NUMBER = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private long initBits = 31L;
        @Nullable
        private String value;
        private int majorVersionNumber;
        private int minorVersionNumber;
        private int patchVersionNumber;
        @Nullable
        private Integer firstSequenceVersionNumber;
        @Nullable
        private Integer secondSequenceVersionNumber;
        @Nullable
        private SlsVersionType type;

        public Builder() {
            if (!(this instanceof OrderableSlsVersion.Builder)) {
                throw new UnsupportedOperationException("Use: new OrderableSlsVersion.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder from(OrderableSlsVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder from(SlsVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (OrderableSlsVersion.Builder)this;
        }

        private void from(Object object) {
            OptionalInt firstSequenceVersionNumberOptional;
            OptionalInt secondSequenceVersionNumberOptional;
            SlsVersion instance;
            long bits = 0L;
            if (object instanceof OrderableSlsVersion) {
                instance = (OrderableSlsVersion)object;
                if ((bits & 1L) == 0L) {
                    this.minorVersionNumber(instance.getMinorVersionNumber());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.patchVersionNumber(instance.getPatchVersionNumber());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    secondSequenceVersionNumberOptional = instance.secondSequenceVersionNumber();
                    if (secondSequenceVersionNumberOptional.isPresent()) {
                        this.secondSequenceVersionNumber(secondSequenceVersionNumberOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    firstSequenceVersionNumberOptional = instance.firstSequenceVersionNumber();
                    if (firstSequenceVersionNumberOptional.isPresent()) {
                        this.firstSequenceVersionNumber(firstSequenceVersionNumberOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.type(instance.getType());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.value(instance.getValue());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.majorVersionNumber(instance.getMajorVersionNumber());
                    bits |= 0x40L;
                }
            }
            if (object instanceof SlsVersion) {
                instance = (SlsVersion)object;
                if ((bits & 1L) == 0L) {
                    this.minorVersionNumber(instance.getMinorVersionNumber());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.patchVersionNumber(instance.getPatchVersionNumber());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    secondSequenceVersionNumberOptional = instance.secondSequenceVersionNumber();
                    if (secondSequenceVersionNumberOptional.isPresent()) {
                        this.secondSequenceVersionNumber(secondSequenceVersionNumberOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    firstSequenceVersionNumberOptional = instance.firstSequenceVersionNumber();
                    if (firstSequenceVersionNumberOptional.isPresent()) {
                        this.firstSequenceVersionNumber(firstSequenceVersionNumberOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.type(instance.getType());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.value(instance.getValue());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.majorVersionNumber(instance.getMajorVersionNumber());
                    bits |= 0x40L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder majorVersionNumber(int majorVersionNumber) {
            this.majorVersionNumber = majorVersionNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder minorVersionNumber(int minorVersionNumber) {
            this.minorVersionNumber = minorVersionNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder patchVersionNumber(int patchVersionNumber) {
            this.patchVersionNumber = patchVersionNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder firstSequenceVersionNumber(int firstSequenceVersionNumber) {
            this.firstSequenceVersionNumber = firstSequenceVersionNumber;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder firstSequenceVersionNumber(OptionalInt firstSequenceVersionNumber) {
            this.firstSequenceVersionNumber = firstSequenceVersionNumber.isPresent() ? Integer.valueOf(firstSequenceVersionNumber.getAsInt()) : null;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder secondSequenceVersionNumber(int secondSequenceVersionNumber) {
            this.secondSequenceVersionNumber = secondSequenceVersionNumber;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder secondSequenceVersionNumber(OptionalInt secondSequenceVersionNumber) {
            this.secondSequenceVersionNumber = secondSequenceVersionNumber.isPresent() ? Integer.valueOf(secondSequenceVersionNumber.getAsInt()) : null;
            return (OrderableSlsVersion.Builder)this;
        }

        @CanIgnoreReturnValue
        public final OrderableSlsVersion.Builder type(SlsVersionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (OrderableSlsVersion.Builder)this;
        }

        public OrderableSlsVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOrderableSlsVersion(this.value, this.majorVersionNumber, this.minorVersionNumber, this.patchVersionNumber, this.firstSequenceVersionNumber, this.secondSequenceVersionNumber, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("majorVersionNumber");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("minorVersionNumber");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("patchVersionNumber");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build OrderableSlsVersion, some of required attributes are not set " + attributes;
        }
    }
}

