/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.regex.Matcher;

interface MatchResult {
    public int groupAsInt(int var1);

    public int groupCount();

    public static final class Int3MatchResult
    implements MatchResult {
        private final int first;
        private final int second;
        private final int third;

        Int3MatchResult(int first, int second, int third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        @Override
        public int groupAsInt(int group) {
            switch (group) {
                case 1: {
                    return this.first;
                }
                case 2: {
                    return this.second;
                }
                case 3: {
                    return this.third;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int groupCount() {
            return 3;
        }
    }

    public static final class RegexMatchResult
    implements MatchResult {
        private static final int RADIX = 10;
        private final String string;
        private final Matcher matcher;

        RegexMatchResult(String string, Matcher matcher) {
            this.string = string;
            this.matcher = matcher;
        }

        @Override
        public int groupAsInt(int group) {
            int groupStart = this.matcher.start(group);
            int groupEnd = this.matcher.end(group);
            if (groupStart == -1) {
                throw new NumberFormatException();
            }
            int integer = Integer.parseUnsignedInt(this.string, groupStart, groupEnd, 10);
            if (integer < 0) {
                throw this.safeIllegalStateException(groupStart, groupEnd);
            }
            return integer;
        }

        @Override
        public int groupCount() {
            return this.matcher.groupCount();
        }

        private SafeIllegalStateException safeIllegalStateException(int groupStart, int groupEnd) {
            return new SafeIllegalStateException("Can't parse segment as integer as it overflowed", SafeArg.of("string", this.string), SafeArg.of("segment", this.string.substring(groupStart, groupEnd)));
        }
    }
}

