/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.palantir.sls.versions.ImmutableNonOrderableSlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.MatchResult;
import shadow.palantir.driver.com.palantir.sls.versions.OrderableSlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersionType;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable
public abstract class NonOrderableSlsVersion
extends SlsVersion {
    @JsonCreator
    public static NonOrderableSlsVersion valueOf(String value) {
        Optional<NonOrderableSlsVersion> optional = NonOrderableSlsVersion.safeValueOf(value);
        Preconditions.checkArgument(optional.isPresent(), "Not a non-orderable version: {value}", UnsafeArg.of("value", value));
        return optional.get();
    }

    public static Optional<NonOrderableSlsVersion> safeValueOf(String value) {
        if (value == null) {
            return Optional.empty();
        }
        MatchResult groups = SlsVersionType.NON_ORDERABLE.getParser().tryParse(value);
        if (groups == null) {
            return Optional.empty();
        }
        return Optional.of(new Builder().value(value).majorVersionNumber(groups.groupAsInt(1)).minorVersionNumber(groups.groupAsInt(2)).patchVersionNumber(groups.groupAsInt(3)).type(SlsVersionType.NON_ORDERABLE).build());
    }

    public static boolean check(String coordinate) {
        return NonOrderableSlsVersion.safeValueOf(coordinate).isPresent() && !OrderableSlsVersion.check(coordinate);
    }

    public final String toString() {
        return this.getValue();
    }

    public static final class Builder
    extends ImmutableNonOrderableSlsVersion.Builder {
    }
}

