/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.UnsafeArg;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.palantir.sls.versions.ImmutableOrderableSlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.MatchResult;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersionType;
import shadow.palantir.driver.com.palantir.sls.versions.VersionComparator;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable
public abstract class OrderableSlsVersion
extends SlsVersion
implements Comparable<OrderableSlsVersion> {
    private static final SlsVersionType[] ORDERED_VERSION_TYPES = new SlsVersionType[]{SlsVersionType.RELEASE, SlsVersionType.RELEASE_CANDIDATE, SlsVersionType.RELEASE_CANDIDATE_SNAPSHOT, SlsVersionType.RELEASE_SNAPSHOT};

    @JsonCreator
    public static OrderableSlsVersion valueOf(String value) {
        Optional<OrderableSlsVersion> optional = OrderableSlsVersion.safeValueOf(value);
        Preconditions.checkArgument(optional.isPresent(), "Not an orderable version: {value}", UnsafeArg.of("value", value));
        return optional.get();
    }

    public static Optional<OrderableSlsVersion> safeValueOf(String value) {
        if (value == null) {
            return Optional.empty();
        }
        for (SlsVersionType type : ORDERED_VERSION_TYPES) {
            MatchResult groups = type.getParser().tryParse(value);
            if (groups == null) continue;
            return Optional.of(OrderableSlsVersion.construct(type, value, groups));
        }
        return Optional.empty();
    }

    private static OrderableSlsVersion construct(SlsVersionType type, String value, MatchResult groups) {
        Builder orderableSlsVersion = new Builder().type(type).value(value).majorVersionNumber(groups.groupAsInt(1)).minorVersionNumber(groups.groupAsInt(2)).patchVersionNumber(groups.groupAsInt(3));
        if (groups.groupCount() >= 4) {
            orderableSlsVersion.firstSequenceVersionNumber(groups.groupAsInt(4));
        }
        if (groups.groupCount() >= 5) {
            orderableSlsVersion.secondSequenceVersionNumber(groups.groupAsInt(5));
        }
        return orderableSlsVersion.build();
    }

    public static boolean check(String coordinate) {
        return OrderableSlsVersion.safeValueOf(coordinate).isPresent();
    }

    public final String toString() {
        return this.getValue();
    }

    @Override
    public final int compareTo(OrderableSlsVersion other) {
        return VersionComparator.INSTANCE.compare(this, other);
    }

    public static class Builder
    extends ImmutableOrderableSlsVersion.Builder {
    }
}

