/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

final class Parsers {
    static final int MAGIC_X_NUMBER = -1;
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final int PARSE_FAILED = Integer.MIN_VALUE;

    private Parsers() {
    }

    static long numberOrX(String string, int startIndex) {
        long xResult = Parsers.literalX(string, startIndex);
        if (Parsers.isOk(xResult)) {
            return Parsers.ok(Parsers.getIndex(xResult), -1);
        }
        long numberResult = Parsers.number(string, startIndex);
        if (Parsers.isOk(numberResult)) {
            return numberResult;
        }
        return Parsers.fail(startIndex);
    }

    static long number(String string, int startIndex) {
        int codepoint;
        int next;
        int len = string.length();
        for (next = startIndex; next < len && Character.isDigit(codepoint = string.codePointAt(next)); ++next) {
        }
        if (next == startIndex) {
            return Parsers.fail(startIndex);
        }
        if (next == startIndex + 1) {
            return Parsers.ok(next, Character.digit(string.codePointAt(startIndex), 10));
        }
        try {
            int result = Integer.parseUnsignedInt(string, startIndex, next, 10);
            if (result < 0) {
                return Parsers.fail(startIndex);
            }
            return Parsers.ok(next, result);
        }
        catch (NumberFormatException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("exceeds range of unsigned int.")) {
                return Parsers.fail(startIndex);
            }
            throw e;
        }
    }

    private static long literalX(String string, int startIndex) {
        if (startIndex < string.length() && string.codePointAt(startIndex) == 120) {
            return Parsers.ok(startIndex + 1, 0);
        }
        return Parsers.fail(startIndex);
    }

    static long literalDot(String string, int startIndex) {
        if (startIndex < string.length() && string.codePointAt(startIndex) == 46) {
            return Parsers.ok(startIndex + 1, 0);
        }
        return Parsers.fail(startIndex);
    }

    static long ok(int index, int result) {
        return (long)index << 32 | (long)result & 0xFFFFFFFFL;
    }

    static long fail(int index) {
        return (long)index << 32 | 0x80000000L;
    }

    static boolean isOk(long state) {
        return Parsers.getResult(state) != Integer.MIN_VALUE;
    }

    static boolean failed(long state) {
        return !Parsers.isOk(state);
    }

    static int getResult(long state) {
        return (int)(state & 0xFFFFFFFFL);
    }

    static int getIndex(long state) {
        return (int)(state >>> 32);
    }
}

