/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.com.palantir.sls.versions.MatchResult;
import shadow.palantir.driver.com.palantir.sls.versions.Parser;
import shadow.palantir.driver.javax.annotation.Nullable;

@Immutable
final class RegexParser
implements Parser {
    private final Pattern pattern;

    RegexParser(Pattern pattern) {
        this.pattern = pattern;
    }

    static RegexParser of(String regex) {
        Pattern pattern = Pattern.compile(regex);
        return new RegexParser(pattern);
    }

    @Override
    @Nullable
    public MatchResult tryParse(String string) {
        Matcher matcher = this.pattern.matcher(string);
        return matcher.matches() ? new MatchResult.RegexMatchResult(string, matcher) : null;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }
}

