/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.sls.versions.NonOrderableSlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.OrderableSlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersionType;
import shadow.palantir.driver.org.immutables.value.Value;

public abstract class SlsVersion
implements Serializable {
    @JsonCreator
    public static SlsVersion valueOf(String value) {
        Optional<OrderableSlsVersion> optionalOrderableVersion = OrderableSlsVersion.safeValueOf(value);
        if (optionalOrderableVersion.isPresent()) {
            return optionalOrderableVersion.get();
        }
        Optional<NonOrderableSlsVersion> optionalNonOrderableVersion = NonOrderableSlsVersion.safeValueOf(value);
        if (optionalNonOrderableVersion.isPresent()) {
            return optionalNonOrderableVersion.get();
        }
        throw new SafeIllegalArgumentException("Value is neither an orderable nor a non-orderable version", UnsafeArg.of("value", value));
    }

    public static boolean check(String coordinate) {
        try {
            SlsVersion.valueOf(coordinate);
            return true;
        }
        catch (SafeIllegalArgumentException e) {
            return false;
        }
    }

    @JsonValue
    @Value.Auxiliary
    public abstract String getValue();

    public abstract int getMajorVersionNumber();

    public abstract int getMinorVersionNumber();

    public abstract int getPatchVersionNumber();

    public abstract OptionalInt firstSequenceVersionNumber();

    public abstract OptionalInt secondSequenceVersionNumber();

    public abstract SlsVersionType getType();
}

