/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import java.util.regex.Pattern;
import shadow.palantir.driver.com.palantir.sls.versions.Parser;
import shadow.palantir.driver.com.palantir.sls.versions.RegexParser;
import shadow.palantir.driver.com.palantir.sls.versions.ReleaseVersionParser;

public enum SlsVersionType {
    RELEASE_SNAPSHOT(RegexParser.of("^([0-9]+)\\.([0-9]+)\\.([0-9]+)-([0-9]+)-g[a-f0-9]+$"), 4),
    RELEASE(ReleaseVersionParser.INSTANCE, 3),
    RELEASE_CANDIDATE_SNAPSHOT(RegexParser.of("^([0-9]+)\\.([0-9]+)\\.([0-9]+)-rc([0-9]+)-([0-9]+)-g[a-f0-9]+$"), 2),
    RELEASE_CANDIDATE(RegexParser.of("^([0-9]+)\\.([0-9]+)\\.([0-9]+)-rc([0-9]+)$"), 1),
    NON_ORDERABLE(RegexParser.of("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-[a-z0-9-]+)?(\\.dirty)?$"), 0);

    private final Parser parser;
    private final int priority;

    public Pattern getPattern() {
        return this.parser.getPattern();
    }

    Parser getParser() {
        return this.parser;
    }

    private SlsVersionType(Parser parser, int priority) {
        this.parser = parser;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isSnapshot() {
        return this == RELEASE_SNAPSHOT || this == RELEASE_CANDIDATE_SNAPSHOT;
    }

    public boolean isReleaseCandidate() {
        return this == RELEASE_CANDIDATE || this == RELEASE_CANDIDATE_SNAPSHOT;
    }
}

