/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.sls.versions;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import java.util.Comparator;
import java.util.OptionalInt;
import shadow.palantir.driver.com.palantir.sls.versions.OrderableSlsVersion;
import shadow.palantir.driver.com.palantir.sls.versions.SlsVersionType;

public enum VersionComparator implements Comparator<OrderableSlsVersion>
{
    INSTANCE;


    @Override
    public int compare(OrderableSlsVersion left, OrderableSlsVersion right) {
        if (left.getValue().equals(right.getValue())) {
            return 0;
        }
        int mainVersionComparison = this.compareMainVersion(left, right);
        if (mainVersionComparison != 0) {
            return mainVersionComparison;
        }
        if (left.getType() == SlsVersionType.RELEASE || right.getType() == SlsVersionType.RELEASE) {
            return Integer.compare(left.getType().getPriority(), right.getType().getPriority());
        }
        if (left.getType() == SlsVersionType.RELEASE_SNAPSHOT && right.getType() == SlsVersionType.RELEASE_SNAPSHOT) {
            return this.compareFirstSequenceVersions(left, right);
        }
        if (left.getType() == SlsVersionType.RELEASE_SNAPSHOT) {
            return 1;
        }
        if (right.getType() == SlsVersionType.RELEASE_SNAPSHOT) {
            return -1;
        }
        return this.compareSuffix(left, right);
    }

    private int compareMainVersion(OrderableSlsVersion left, OrderableSlsVersion right) {
        if (left.getMajorVersionNumber() != right.getMajorVersionNumber()) {
            return left.getMajorVersionNumber() > right.getMajorVersionNumber() ? 1 : -1;
        }
        if (left.getMinorVersionNumber() != right.getMinorVersionNumber()) {
            return left.getMinorVersionNumber() > right.getMinorVersionNumber() ? 1 : -1;
        }
        if (left.getPatchVersionNumber() != right.getPatchVersionNumber()) {
            return left.getPatchVersionNumber() > right.getPatchVersionNumber() ? 1 : -1;
        }
        return 0;
    }

    private int compareSuffix(OrderableSlsVersion left, OrderableSlsVersion right) {
        int rcCompare = this.compareFirstSequenceVersions(left, right);
        if (rcCompare != 0) {
            return rcCompare;
        }
        OptionalInt leftInt = left.secondSequenceVersionNumber();
        OptionalInt rightInt = right.secondSequenceVersionNumber();
        return Integer.compare(leftInt.orElse(-1), rightInt.orElse(-1));
    }

    private int compareFirstSequenceVersions(OrderableSlsVersion left, OrderableSlsVersion right) {
        OptionalInt leftInt = left.firstSequenceVersionNumber();
        OptionalInt rightInt = right.firstSequenceVersionNumber();
        Preconditions.checkArgument(leftInt.isPresent(), "Expected to find a first sequence number for version", SafeArg.of("version", left.getValue()));
        Preconditions.checkArgument(rightInt.isPresent(), "Expected to find a first sequence number for version", SafeArg.of("version", right.getValue()));
        return Integer.compare(leftInt.getAsInt(), rightInt.getAsInt());
    }
}

