/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tokens.auth;

import com.palantir.logsafe.DoNotLog;
import shadow.palantir.driver.com.palantir.tokens.auth.BearerToken;
import shadow.palantir.driver.com.palantir.tokens.auth.ImmutableAuthHeader;
import shadow.palantir.driver.org.immutables.value.Value;

@DoNotLog
@Value.Immutable
public abstract class AuthHeader {
    @Value.Parameter
    public abstract BearerToken getBearerToken();

    public static AuthHeader valueOf(String authHeader) {
        BearerToken bearerToken = BearerToken.valueOf(authHeader.regionMatches(true, 0, "Bearer ", 0, 7) ? authHeader.substring(7) : authHeader);
        return ImmutableAuthHeader.of(bearerToken);
    }

    public static AuthHeader of(BearerToken bearerToken) {
        return ImmutableAuthHeader.of(bearerToken);
    }

    @DoNotLog
    public final String toString() {
        return "Bearer " + this.getBearerToken().getToken();
    }
}

