/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tokens.auth;

import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.security.MessageDigest;
import java.util.BitSet;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.tokens.auth.ImmutableBearerToken;
import shadow.palantir.driver.org.immutables.value.Value;

@DoNotLog
@Value.Immutable
public abstract class BearerToken {
    private static final String VALIDATION_PATTERN_STRING = "^[A-Za-z0-9\\-\\._~\\+/]+=*$";
    private static final BitSet allowedCharacters = new BitSet();

    @JsonValue
    @DoNotLog
    @Value.Parameter
    public abstract String getToken();

    @DoNotLog
    @Value.Derived
    byte[] getTokenAsBytes() {
        String token = this.getToken();
        byte[] result = new byte[token.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)token.charAt(i);
        }
        return result;
    }

    @JsonCreator
    public static BearerToken valueOf(String token) {
        Preconditions.checkArgument(token != null, "BearerToken cannot be null");
        Preconditions.checkArgument(!token.isEmpty(), "BearerToken cannot be empty");
        if (!BearerToken.isValidBearerToken(token)) {
            throw new SafeIllegalArgumentException("BearerToken must match pattern", SafeArg.of("validationPattern", VALIDATION_PATTERN_STRING));
        }
        return ImmutableBearerToken.of(token);
    }

    private static boolean isValidBearerToken(String token) {
        int cursor;
        int length = token.length();
        for (cursor = 0; cursor < length && allowedCharacters.get(token.charAt(cursor)); ++cursor) {
        }
        if (cursor == 0) {
            return false;
        }
        while (cursor < length) {
            if (token.charAt(cursor) != '=') {
                return false;
            }
            ++cursor;
        }
        return true;
    }

    @DoNotLog
    public final String toString() {
        return this.getToken();
    }

    public final boolean equals(Object other) {
        return other instanceof BearerToken && MessageDigest.isEqual(((BearerToken)other).getTokenAsBytes(), this.getTokenAsBytes());
    }

    @DoNotLog
    public final int hashCode() {
        return this.getToken().hashCode();
    }

    static {
        allowedCharacters.set(65, 91);
        allowedCharacters.set(97, 123);
        allowedCharacters.set(48, 58);
        allowedCharacters.set(45);
        allowedCharacters.set(46);
        allowedCharacters.set(95);
        allowedCharacters.set(126);
        allowedCharacters.set(43);
        allowedCharacters.set(47);
    }
}

