/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Safe;
import java.util.Map;
import shadow.palantir.driver.com.palantir.tracing.MapTagTranslator;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;

public class CloseableTracer
implements AutoCloseable {
    private static final CloseableTracer INSTANCE = new CloseableTracer();

    private CloseableTracer() {
    }

    public static CloseableTracer startSpan(@Safe String operation) {
        return CloseableTracer.startSpan(operation, SpanType.LOCAL);
    }

    public static CloseableTracer startSpan(@Safe String operation, @Safe Map<String, String> metadata) {
        return CloseableTracer.startSpan(operation, MapTagTranslator.INSTANCE, metadata, SpanType.LOCAL);
    }

    public static CloseableTracer startSpan(@Safe String operation, SpanType spanType) {
        Tracer.fastStartSpan(operation, spanType);
        return INSTANCE;
    }

    public static <T> CloseableTracer startSpan(@Safe String operation, TagTranslator<? super T> translator, T data) {
        return CloseableTracer.startSpan(operation, translator, data, SpanType.LOCAL);
    }

    public static <T> CloseableTracer startSpan(@Safe String operation, TagTranslator<? super T> translator, T data, SpanType spanType) {
        Tracer.fastStartSpan(operation, spanType);
        if (!Tracer.isTraceObservable() || translator.isEmpty(data)) {
            return INSTANCE;
        }
        return new TaggedCloseableTracer<T>(translator, data);
    }

    @Override
    public void close() {
        Tracer.fastCompleteSpan();
    }

    private static final class TaggedCloseableTracer<T>
    extends CloseableTracer {
        private final TagTranslator<? super T> translator;
        private final T data;

        TaggedCloseableTracer(TagTranslator<? super T> translator, T data) {
            this.translator = translator;
            this.data = data;
        }

        @Override
        public void close() {
            Tracer.fastCompleteSpan(this.translator, this.data);
        }
    }
}

