/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Preconditions;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;

final class CompositeTagTranslator<S>
implements TagTranslator<S> {
    private final TagTranslator<? super S> first;
    private final TagTranslator<? super S> second;

    CompositeTagTranslator(TagTranslator<? super S> first, TagTranslator<? super S> second) {
        this.first = Preconditions.checkNotNull(first, "First TagTranslator is required");
        this.second = Preconditions.checkNotNull(second, "Second TagTranslator is required");
    }

    @Override
    public <T> void translate(TagTranslator.TagAdapter<T> adapter, T target, S data) {
        this.first.translate(adapter, target, data);
        this.second.translate(adapter, target, data);
    }

    @Override
    public boolean isEmpty(S data) {
        return this.first.isEmpty(data) && this.second.isEmpty(data);
    }

    public String toString() {
        return "CompositeTagTranslator{first=" + this.first + ", second=" + this.second + "}";
    }
}

