/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Safe;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.errorprone.annotations.MustBeClosed;
import shadow.palantir.driver.com.palantir.tracing.Trace;
import shadow.palantir.driver.com.palantir.tracing.TraceState;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tracing.Tracers;
import shadow.palantir.driver.com.palantir.tracing.api.OpenSpan;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class DeferredTracer
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String DEFAULT_OPERATION = "DeferredTracer(unnamed operation)";
    @Nullable
    private final TraceState traceState;
    private final boolean isObservable;
    @Nullable
    private final String operation;
    @Nullable
    private final Map<String, String> metadata;
    @Nullable
    private final String parentSpanId;
    private static final Function<Trace, CloseableTrace> CLOSEABLE_TRACE_FUNCTION = originalTrace -> () -> {
        DefaultCloseableTrace.INSTANCE.close();
        Tracer.setTrace(originalTrace);
    };

    @Deprecated
    public DeferredTracer() {
        this(Optional.empty());
    }

    @Deprecated
    public DeferredTracer(@Safe Optional<String> operation) {
        this(operation.orElse(DEFAULT_OPERATION));
    }

    public DeferredTracer(@Safe String operation, @Safe Map<String, String> metadata) {
        Optional<Trace> maybeTrace = Tracer.copyTrace();
        if (maybeTrace.isPresent()) {
            Trace trace = maybeTrace.get();
            this.traceState = trace.getTraceState();
            this.isObservable = trace.isObservable();
            this.parentSpanId = trace.top().map(OpenSpan::getSpanId).orElse(null);
            this.operation = operation;
            this.metadata = metadata;
        } else {
            this.traceState = null;
            this.isObservable = false;
            this.parentSpanId = null;
            this.operation = null;
            this.metadata = null;
        }
    }

    public DeferredTracer(@Safe String operation) {
        this(operation, ImmutableMap.of());
    }

    public <T, E extends Throwable> T withTrace(Tracers.ThrowingCallable<T, E> inner) throws E {
        try (CloseableTrace ignored = this.withTrace();){
            T t = inner.call();
            return t;
        }
    }

    @MustBeClosed
    CloseableTrace withTrace() {
        if (this.traceState == null) {
            return NopCloseableTrace.INSTANCE;
        }
        Optional<Trace> originalTrace = Tracer.getAndClearTraceIfPresent();
        Tracer.setTrace(Trace.of(this.isObservable, this.traceState));
        if (this.parentSpanId != null) {
            Tracer.fastStartSpan(this.operation, this.parentSpanId, SpanType.LOCAL);
        } else {
            Tracer.fastStartSpan(this.operation);
        }
        if (this.isObservable && this.metadata != null && !this.metadata.isEmpty()) {
            return new TaggedCloseableTrace(originalTrace, this.metadata);
        }
        return originalTrace.map(CLOSEABLE_TRACE_FUNCTION).orElse(DefaultCloseableTrace.INSTANCE);
    }

    static interface CloseableTrace
    extends Closeable {
        @Override
        public void close();
    }

    private static final class TaggedCloseableTrace
    implements CloseableTrace {
        private final Map<String, String> metadata;
        private final Optional<Trace> originalTrace;

        TaggedCloseableTrace(Optional<Trace> originalTrace, Map<String, String> metadata) {
            this.metadata = metadata;
            this.originalTrace = originalTrace;
        }

        @Override
        public void close() {
            Tracer.fastCompleteSpan(this.metadata);
            if (this.originalTrace.isPresent()) {
                Tracer.setTrace(this.originalTrace.get());
            } else if (Tracer.hasTraceId()) {
                Tracer.getAndClearTrace();
            }
        }
    }

    private static enum DefaultCloseableTrace implements CloseableTrace
    {
        INSTANCE;


        @Override
        public void close() {
            Tracer.fastCompleteSpan();
            if (Tracer.hasTraceId()) {
                Tracer.getAndClearTrace();
            }
        }
    }

    private static enum NopCloseableTrace implements CloseableTrace
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }
}

