/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Safe;
import java.util.Map;
import java.util.Optional;
import shadow.palantir.driver.com.google.errorprone.annotations.MustBeClosed;
import shadow.palantir.driver.com.palantir.tracing.CloseableSpan;
import shadow.palantir.driver.com.palantir.tracing.Detached;
import shadow.palantir.driver.com.palantir.tracing.MapTagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Observability;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;

public interface DetachedSpan
extends Detached {
    @CheckReturnValue
    public static DetachedSpan start(@Safe String operation) {
        return DetachedSpan.start(operation, SpanType.LOCAL);
    }

    @CheckReturnValue
    public static DetachedSpan start(@Safe String operation, SpanType type) {
        return Tracer.detachInternal(operation, type);
    }

    @CheckReturnValue
    public static DetachedSpan start(Observability observability, String traceId, Optional<String> parentSpanId, @Safe String operation, SpanType type) {
        return DetachedSpan.start(observability, traceId, Optional.empty(), parentSpanId, operation, type);
    }

    @CheckReturnValue
    public static DetachedSpan start(Observability observability, String traceId, Optional<String> forUserAgent, Optional<String> parentSpanId, @Safe String operation, SpanType type) {
        return Tracer.detachInternal(observability, traceId, forUserAgent, parentSpanId, operation, type);
    }

    @CheckReturnValue
    public static Detached detach() {
        return Tracer.detachInternal();
    }

    @MustBeClosed
    default public CloseableSpan completeAndStartChild(@Safe String operationName, SpanType type) {
        CloseableSpan child = this.childSpan(operationName, type);
        this.complete();
        return child;
    }

    @MustBeClosed
    default public CloseableSpan completeAndStartChild(@Safe String operationName) {
        return this.completeAndStartChild(operationName, SpanType.LOCAL);
    }

    public void complete();

    default public void complete(@Safe Map<String, String> metadata) {
        this.complete(MapTagTranslator.INSTANCE, metadata);
    }

    public <T> void complete(TagTranslator<? super T> var1, T var2);
}

