/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.tracing.TraceMetadata;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TraceMetadata", generator="Immutables")
@Immutable
final class ImmutableTraceMetadata
implements TraceMetadata {
    private final String traceId;
    @Nullable
    private final String requestId;
    private final String spanId;
    @Nullable
    private final String parentSpanId;

    private ImmutableTraceMetadata(String traceId, @Nullable String requestId, String spanId, @Nullable String parentSpanId) {
        this.traceId = traceId;
        this.requestId = requestId;
        this.spanId = spanId;
        this.parentSpanId = parentSpanId;
    }

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public Optional<String> getRequestId() {
        return Optional.ofNullable(this.requestId);
    }

    @Override
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public Optional<String> getParentSpanId() {
        return Optional.ofNullable(this.parentSpanId);
    }

    public final ImmutableTraceMetadata withTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "traceId");
        if (this.traceId.equals(newValue)) {
            return this;
        }
        return new ImmutableTraceMetadata(newValue, this.requestId, this.spanId, this.parentSpanId);
    }

    public final ImmutableTraceMetadata withRequestId(String value) {
        String newValue = Objects.requireNonNull(value, "requestId");
        if (Objects.equals(this.requestId, newValue)) {
            return this;
        }
        return new ImmutableTraceMetadata(this.traceId, newValue, this.spanId, this.parentSpanId);
    }

    public final ImmutableTraceMetadata withRequestId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.requestId, value)) {
            return this;
        }
        return new ImmutableTraceMetadata(this.traceId, value, this.spanId, this.parentSpanId);
    }

    public final ImmutableTraceMetadata withSpanId(String value) {
        String newValue = Objects.requireNonNull(value, "spanId");
        if (this.spanId.equals(newValue)) {
            return this;
        }
        return new ImmutableTraceMetadata(this.traceId, this.requestId, newValue, this.parentSpanId);
    }

    public final ImmutableTraceMetadata withParentSpanId(String value) {
        String newValue = Objects.requireNonNull(value, "parentSpanId");
        if (Objects.equals(this.parentSpanId, newValue)) {
            return this;
        }
        return new ImmutableTraceMetadata(this.traceId, this.requestId, this.spanId, newValue);
    }

    public final ImmutableTraceMetadata withParentSpanId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.parentSpanId, value)) {
            return this;
        }
        return new ImmutableTraceMetadata(this.traceId, this.requestId, this.spanId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTraceMetadata && this.equalTo(0, (ImmutableTraceMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableTraceMetadata another) {
        return this.traceId.equals(another.traceId) && Objects.equals(this.requestId, another.requestId) && this.spanId.equals(another.spanId) && Objects.equals(this.parentSpanId, another.parentSpanId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.traceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.requestId);
        h += (h << 5) + this.spanId.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentSpanId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TraceMetadata").omitNullValues().add("traceId", this.traceId).add("requestId", this.requestId).add("spanId", this.spanId).add("parentSpanId", this.parentSpanId).toString();
    }

    public static ImmutableTraceMetadata copyOf(TraceMetadata instance) {
        if (instance instanceof ImmutableTraceMetadata) {
            return (ImmutableTraceMetadata)instance;
        }
        return new TraceMetadata.Builder().from(instance).build();
    }

    @Generated(from="TraceMetadata", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_TRACE_ID = 1L;
        private static final long INIT_BIT_SPAN_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String traceId;
        @Nullable
        private String requestId;
        @Nullable
        private String spanId;
        @Nullable
        private String parentSpanId;

        public Builder() {
            if (!(this instanceof TraceMetadata.Builder)) {
                throw new UnsupportedOperationException("Use: new TraceMetadata.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final TraceMetadata.Builder from(TraceMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.traceId(instance.getTraceId());
            Optional<String> requestIdOptional = instance.getRequestId();
            if (requestIdOptional.isPresent()) {
                this.requestId(requestIdOptional);
            }
            this.spanId(instance.getSpanId());
            Optional<String> parentSpanIdOptional = instance.getParentSpanId();
            if (parentSpanIdOptional.isPresent()) {
                this.parentSpanId(parentSpanIdOptional);
            }
            return (TraceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TraceMetadata.Builder traceId(String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (TraceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TraceMetadata.Builder requestId(String requestId) {
            this.requestId = Objects.requireNonNull(requestId, "requestId");
            return (TraceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TraceMetadata.Builder requestId(Optional<String> requestId) {
            this.requestId = requestId.orElse(null);
            return (TraceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TraceMetadata.Builder spanId(String spanId) {
            this.spanId = Objects.requireNonNull(spanId, "spanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (TraceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TraceMetadata.Builder parentSpanId(String parentSpanId) {
            this.parentSpanId = Objects.requireNonNull(parentSpanId, "parentSpanId");
            return (TraceMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final TraceMetadata.Builder parentSpanId(Optional<String> parentSpanId) {
            this.parentSpanId = parentSpanId.orElse(null);
            return (TraceMetadata.Builder)this;
        }

        public ImmutableTraceMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTraceMetadata(this.traceId, this.requestId, this.spanId, this.parentSpanId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("traceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("spanId");
            }
            return "Cannot build TraceMetadata, some of required attributes are not set " + attributes;
        }
    }
}

