/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.google.errorprone.annotations.MustBeClosed;
import shadow.palantir.driver.com.palantir.tracing.CloseableSpan;
import shadow.palantir.driver.com.palantir.tracing.CloseableTracer;
import shadow.palantir.driver.com.palantir.tracing.Detached;
import shadow.palantir.driver.com.palantir.tracing.DetachedSpan;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;

enum NopDetached implements Detached
{
    INSTANCE;

    private static final CloseableSpan COMPLETE_SPAN;

    @Override
    @MustBeClosed
    public <T> CloseableSpan childSpan(String operationName, TagTranslator<? super T> translator, T data, SpanType type) {
        return CloseableTracer.startSpan(operationName, translator, data, type)::close;
    }

    @Override
    @MustBeClosed
    public CloseableSpan childSpan(@Safe String operationName, SpanType type) {
        Tracer.fastStartSpan(operationName, type);
        return COMPLETE_SPAN;
    }

    @Override
    @MustBeClosed
    public CloseableSpan attach() {
        return NopCloseableSpan.INSTANCE;
    }

    @Override
    public DetachedSpan childDetachedSpan(String operation, SpanType type) {
        return DetachedSpan.start(operation, type);
    }

    static {
        COMPLETE_SPAN = Tracer::fastCompleteSpan;
    }

    private static enum NopCloseableSpan implements CloseableSpan
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }
}

