/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import java.util.concurrent.ThreadLocalRandom;
import shadow.palantir.driver.com.palantir.tracing.AlwaysSampler;
import shadow.palantir.driver.com.palantir.tracing.NeverSampler;
import shadow.palantir.driver.com.palantir.tracing.TraceSampler;

public final class RandomSampler
implements TraceSampler {
    private final float rate;

    @Deprecated
    public RandomSampler(float rate) {
        Preconditions.checkArgument(rate >= 0.0f && rate <= 1.0f, "Rate should be between 0 and 1", SafeArg.of("rate", Float.valueOf(rate)));
        this.rate = rate;
    }

    public static TraceSampler create(float rate) {
        Preconditions.checkArgument(rate >= 0.0f && rate <= 1.0f, "Rate should be between 0 and 1", SafeArg.of("rate", Float.valueOf(rate)));
        if (rate == 0.0f) {
            return NeverSampler.INSTANCE;
        }
        if (rate == 1.0f) {
            return AlwaysSampler.INSTANCE;
        }
        return new RandomSampler(rate);
    }

    @Override
    public boolean sample() {
        return ThreadLocalRandom.current().nextFloat() < this.rate;
    }
}

