/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tracing.TraceState;
import shadow.palantir.driver.com.palantir.tracing.Tracers;
import shadow.palantir.driver.com.palantir.tracing.api.OpenSpan;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;
import shadow.palantir.driver.javax.annotation.Nullable;

public abstract class Trace {
    private final TraceState traceState;

    private Trace(TraceState traceState) {
        Preconditions.checkNotNull(traceState, "Trace state must not be null");
        this.traceState = traceState;
    }

    @CheckReturnValue
    final OpenSpan startSpan(String operation, String parentSpanId, SpanType type) {
        Preconditions.checkState(this.isEmpty(), "Cannot start a span with explicit parent if the current thread's trace is non-empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(parentSpanId), "parentSpanId must be non-empty");
        OpenSpan span = OpenSpan.of(operation, Tracers.randomId(), type, Optional.of(parentSpanId));
        this.push(span);
        return span;
    }

    @CheckReturnValue
    final OpenSpan startSpan(String operation, SpanType type) {
        Optional<OpenSpan> prevState = this.top();
        OpenSpan span = prevState.isPresent() ? OpenSpan.of(operation, Tracers.randomId(), type, Optional.of(prevState.get().getSpanId())) : OpenSpan.of(operation, Tracers.randomId(), type, Optional.empty());
        this.push(span);
        return span;
    }

    abstract void fastStartSpan(String var1, String var2, SpanType var3);

    abstract void fastStartSpan(String var1, SpanType var2);

    protected abstract void push(OpenSpan var1);

    abstract Optional<OpenSpan> top();

    abstract Optional<OpenSpan> pop();

    abstract boolean isEmpty();

    abstract boolean isObservable();

    final TraceState getTraceState() {
        return this.traceState;
    }

    final String getTraceId() {
        return this.traceState.traceId();
    }

    @Nullable
    final String maybeGetRequestId() {
        return this.traceState.requestId();
    }

    final Optional<String> getForUserAgent() {
        return Optional.ofNullable(this.traceState.forUserAgent());
    }

    abstract Trace deepCopy();

    @Deprecated
    static Trace of(boolean isObservable, String traceId, Optional<String> requestId) {
        return Trace.of(isObservable, TraceState.of(traceId, requestId, Optional.empty()));
    }

    static Trace of(boolean isObservable, TraceState traceState) {
        return isObservable ? new Sampled(traceState) : new Unsampled(traceState);
    }

    private static final class Unsampled
    extends Trace {
        private int numberOfSpans;

        private Unsampled(int numberOfSpans, TraceState traceState) {
            super(traceState);
            this.numberOfSpans = numberOfSpans;
            this.validateNumberOfSpans();
        }

        private Unsampled(TraceState traceState) {
            this(0, traceState);
        }

        @Override
        void fastStartSpan(String _operation, String _parentSpanId, SpanType _type) {
            ++this.numberOfSpans;
        }

        @Override
        void fastStartSpan(String _operation, SpanType _type) {
            ++this.numberOfSpans;
        }

        @Override
        protected void push(OpenSpan _span) {
            ++this.numberOfSpans;
        }

        @Override
        Optional<OpenSpan> top() {
            return Optional.empty();
        }

        @Override
        Optional<OpenSpan> pop() {
            this.validateNumberOfSpans();
            if (this.numberOfSpans > 0) {
                --this.numberOfSpans;
            }
            return Optional.empty();
        }

        @Override
        boolean isEmpty() {
            this.validateNumberOfSpans();
            return this.numberOfSpans <= 0;
        }

        @Override
        boolean isObservable() {
            return false;
        }

        @Override
        Trace deepCopy() {
            return new Unsampled(this.numberOfSpans, this.getTraceState());
        }

        private void validateNumberOfSpans() {
            if (this.numberOfSpans < 0) {
                throw new SafeIllegalStateException("Unexpected negative numberOfSpans", SafeArg.of("numberOfSpans", this.numberOfSpans));
            }
        }

        public String toString() {
            return "Trace{numberOfSpans=" + this.numberOfSpans + ", isObservable=false, traceState=" + this.getTraceState() + "}";
        }
    }

    private static final class Sampled
    extends Trace {
        private final Deque<OpenSpan> stack;

        private Sampled(ArrayDeque<OpenSpan> stack, TraceState traceState) {
            super(traceState);
            this.stack = stack;
        }

        private Sampled(TraceState traceState) {
            this(new ArrayDeque<OpenSpan>(), traceState);
        }

        @Override
        void fastStartSpan(String operation, String parentSpanId, SpanType type) {
            this.startSpan(operation, parentSpanId, type);
        }

        @Override
        void fastStartSpan(String operation, SpanType type) {
            this.startSpan(operation, type);
        }

        @Override
        protected void push(OpenSpan span) {
            this.stack.push(span);
        }

        @Override
        Optional<OpenSpan> top() {
            return this.stack.isEmpty() ? Optional.empty() : Optional.of(this.stack.peekFirst());
        }

        @Override
        Optional<OpenSpan> pop() {
            return this.stack.isEmpty() ? Optional.empty() : Optional.of(this.stack.pop());
        }

        @Override
        boolean isEmpty() {
            return this.stack.isEmpty();
        }

        @Override
        boolean isObservable() {
            return true;
        }

        @Override
        Trace deepCopy() {
            return new Sampled(new ArrayDeque<OpenSpan>(this.stack), this.getTraceState());
        }

        public String toString() {
            return "Trace{stack=" + this.stack + ", isObservable=true, state=" + this.getTraceState() + "}";
        }
    }
}

