/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import shadow.palantir.driver.com.palantir.tracing.TraceState;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class TraceLocal<T> {
    @Nullable
    private final Function<? super TraceLocal<?>, T> initialValue;

    private TraceLocal(@Nullable Supplier<T> initialValue) {
        this.initialValue = initialValue == null ? null : _ignored -> Preconditions.checkNotNull(initialValue.get(), "TraceLocal initial value must not be null");
    }

    public static <T> TraceLocal<T> of() {
        return new TraceLocal<T>(null);
    }

    public static <T> TraceLocal<T> withInitialValue(@Nonnull Supplier<T> initialValue) {
        return new TraceLocal<T>(Preconditions.checkNotNull(initialValue, "initial value supplier must not be null"));
    }

    @Nullable
    public T get() {
        TraceState traceState = Tracer.getTraceState();
        if (traceState == null) {
            return null;
        }
        if (this.initialValue == null) {
            Map<TraceLocal<?>, Object> traceLocals = traceState.getTraceLocals();
            if (traceLocals == null) {
                return null;
            }
            return (T)traceLocals.get(this);
        }
        Map<TraceLocal<?>, Object> traceLocals = traceState.getOrCreateTraceLocals();
        return (T)traceLocals.computeIfAbsent(this, this.initialValue);
    }

    @Nullable
    public T set(@Nonnull T value) {
        if (value == null) {
            throw new SafeIllegalArgumentException("value must not be null", new Arg[0]);
        }
        TraceState traceState = Tracer.getTraceState();
        if (traceState == null) {
            return null;
        }
        return (T)traceState.getOrCreateTraceLocals().put(this, value);
    }

    @Nullable
    public T remove() {
        TraceState traceState = Tracer.getTraceState();
        if (traceState == null) {
            return null;
        }
        Map<TraceLocal<?>, Object> traceLocals = traceState.getTraceLocals();
        if (traceLocals == null) {
            return null;
        }
        return (T)traceLocals.remove(this);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

