/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.palantir.tracing.TraceLocal;
import shadow.palantir.driver.javax.annotation.Nullable;

final class TraceState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String traceId;
    @Nullable
    private final String requestId;
    @Nullable
    private final String forUserAgent;
    @Nullable
    private volatile TraceLocalMap traceLocals;
    private static final AtomicReferenceFieldUpdater<TraceState, TraceLocalMap> traceLocalsUpdater = AtomicReferenceFieldUpdater.newUpdater(TraceState.class, TraceLocalMap.class, "traceLocals");

    static TraceState of(String traceId, Optional<String> requestId, Optional<String> forUserAgent) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(traceId), "traceId must be non-empty");
        Preconditions.checkNotNull(requestId, "requestId should be not-null");
        Preconditions.checkNotNull(forUserAgent, "forUserAgent should be not-null");
        return new TraceState(traceId, requestId.orElse(null), forUserAgent.orElse(null));
    }

    private TraceState(String traceId, @Nullable String requestId, @Nullable String forUserAgent) {
        this.traceId = traceId;
        this.requestId = requestId;
        this.forUserAgent = forUserAgent;
        this.traceLocals = null;
    }

    String traceId() {
        return this.traceId;
    }

    @Nullable
    String requestId() {
        return this.requestId;
    }

    @Nullable
    String forUserAgent() {
        return this.forUserAgent;
    }

    Map<TraceLocal<?>, Object> getOrCreateTraceLocals() {
        TraceLocalMap result = traceLocalsUpdater.get(this);
        if (result == null && !traceLocalsUpdater.compareAndSet(this, null, result = new TraceLocalMap())) {
            return traceLocalsUpdater.get(this);
        }
        return result;
    }

    @Nullable
    Map<TraceLocal<?>, Object> getTraceLocals() {
        return this.traceLocals;
    }

    public String toString() {
        return "TraceState{traceId='" + this.traceId + "', requestId='" + this.requestId + "', forUserAgent='" + this.forUserAgent + "'}";
    }

    private static final class TraceLocalMap
    extends ConcurrentHashMap<TraceLocal<?>, Object> {
        private TraceLocalMap() {
        }
    }
}

