/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.slf4j.MDC;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.google.errorprone.annotations.MustBeClosed;
import shadow.palantir.driver.com.palantir.tracing.CloseableSpan;
import shadow.palantir.driver.com.palantir.tracing.Detached;
import shadow.palantir.driver.com.palantir.tracing.DetachedSpan;
import shadow.palantir.driver.com.palantir.tracing.MapTagTranslator;
import shadow.palantir.driver.com.palantir.tracing.NoTagTranslator;
import shadow.palantir.driver.com.palantir.tracing.NopDetached;
import shadow.palantir.driver.com.palantir.tracing.Observability;
import shadow.palantir.driver.com.palantir.tracing.RandomSampler;
import shadow.palantir.driver.com.palantir.tracing.TagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Trace;
import shadow.palantir.driver.com.palantir.tracing.TraceMetadata;
import shadow.palantir.driver.com.palantir.tracing.TraceSampler;
import shadow.palantir.driver.com.palantir.tracing.TraceState;
import shadow.palantir.driver.com.palantir.tracing.Tracers;
import shadow.palantir.driver.com.palantir.tracing.api.OpenSpan;
import shadow.palantir.driver.com.palantir.tracing.api.Span;
import shadow.palantir.driver.com.palantir.tracing.api.SpanObserver;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class Tracer {
    private static final SafeLogger log = SafeLoggerFactory.get(Tracer.class);
    private static final ThreadLocal<Trace> currentTrace = new ThreadLocal();
    private static final Map<String, SpanObserver> observers = new HashMap<String, SpanObserver>();
    private static volatile Consumer<Span> compositeObserver = _span -> {};
    private static volatile TraceSampler sampler = RandomSampler.create(5.0E-4f);
    private static final CloseableSpan DEFAULT_CLOSEABLE_SPAN = Tracer::fastCompleteSpan;
    private static final CloseableSpan REMOVE_TRACE = Tracer::clearCurrentTrace;

    private Tracer() {
    }

    private static Trace createTrace(Observability observability, String traceId, Optional<String> requestId) {
        return Tracer.createTrace(observability, traceId, requestId, Optional.empty());
    }

    private static Trace createTrace(Observability observability, String traceId, Optional<String> requestId, Optional<String> forUserAgent) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(traceId), "traceId must be non-empty");
        boolean observable = Tracer.shouldObserve(observability);
        return Trace.of(observable, TraceState.of(traceId, requestId, forUserAgent));
    }

    private static boolean shouldObserve(Observability observability) {
        return observability == Observability.SAMPLE || observability == Observability.UNDECIDED && sampler.sample();
    }

    @Deprecated
    static TraceMetadata getTraceMetadata() {
        return Tracer.maybeGetTraceMetadata().orElseThrow(() -> new SafeRuntimeException("Trace with no spans in progress", new Arg[0]));
    }

    public static Optional<TraceMetadata> maybeGetTraceMetadata() {
        Trace trace = currentTrace.get();
        if (trace == null) {
            return Optional.empty();
        }
        TraceMetadata.Builder builder = TraceMetadata.builder().traceId(trace.getTraceId());
        String requestId = trace.maybeGetRequestId();
        if (requestId != null) {
            builder.requestId(requestId);
        }
        if (trace.isObservable()) {
            return trace.top().map(openSpan -> builder.spanId(openSpan.getSpanId()).parentSpanId(openSpan.getParentSpanId()).build());
        }
        return Optional.of(builder.spanId(Tracers.randomId()).parentSpanId(Optional.empty()).build());
    }

    @Deprecated
    public static void initTrace(Optional<Boolean> isObservable, String traceId) {
        Observability observability = isObservable.map(observable -> observable != false ? Observability.SAMPLE : Observability.DO_NOT_SAMPLE).orElse(Observability.UNDECIDED);
        Tracer.setTrace(Tracer.createTrace(observability, traceId, Optional.empty()));
    }

    @Deprecated
    public static void initTrace(Observability observability, String traceId) {
        Tracer.setTrace(Tracer.createTrace(observability, traceId, Optional.empty()));
    }

    @Deprecated
    public static void initTraceWithSpan(Observability observability, String traceId, @Safe String operation, String parentSpanId, SpanType type) {
        Tracer.setTrace(Tracer.createTrace(observability, traceId, type == SpanType.SERVER_INCOMING ? Optional.of(Tracers.randomId()) : Optional.empty()));
        Tracer.fastStartSpan(operation, parentSpanId, type);
    }

    public static void initTraceWithSpan(Observability observability, String traceId, @Safe String operation, SpanType type) {
        Tracer.setTrace(Tracer.createTrace(observability, traceId, type == SpanType.SERVER_INCOMING ? Optional.of(Tracers.randomId()) : Optional.empty()));
        Tracer.fastStartSpan(operation, type);
    }

    public static void initTraceWithSpan(Observability observability, String traceId, Optional<String> forUserAgent, @Safe String operation, String parentSpanId, SpanType type) {
        Tracer.setTrace(Tracer.createTrace(observability, traceId, type == SpanType.SERVER_INCOMING ? Optional.of(Tracers.randomId()) : Optional.empty(), forUserAgent));
        Tracer.fastStartSpan(operation, parentSpanId, type);
    }

    public static void initTraceWithSpan(Observability observability, String traceId, Optional<String> forUserAgent, @Safe String operation, SpanType type) {
        Tracer.setTrace(Tracer.createTrace(observability, traceId, type == SpanType.SERVER_INCOMING ? Optional.of(Tracers.randomId()) : Optional.empty(), forUserAgent));
        Tracer.fastStartSpan(operation, type);
    }

    @CheckReturnValue
    public static OpenSpan startSpan(@Safe String operation, String parentSpanId, SpanType type) {
        return Tracer.getOrCreateCurrentTrace().startSpan(operation, parentSpanId, type);
    }

    @CheckReturnValue
    public static OpenSpan startSpan(@Safe String operation, SpanType type) {
        return Tracer.getOrCreateCurrentTrace().startSpan(operation, type);
    }

    @CheckReturnValue
    public static OpenSpan startSpan(@Safe String operation) {
        return Tracer.startSpan(operation, SpanType.LOCAL);
    }

    public static void fastStartSpan(@Safe String operation, String parentSpanId, SpanType type) {
        Tracer.getOrCreateCurrentTrace().fastStartSpan(operation, parentSpanId, type);
    }

    public static void fastStartSpan(@Safe String operation, SpanType type) {
        Tracer.getOrCreateCurrentTrace().fastStartSpan(operation, type);
    }

    public static void fastStartSpan(@Safe String operation) {
        Tracer.fastStartSpan(operation, SpanType.LOCAL);
    }

    static DetachedSpan detachInternal(@Safe String operation, SpanType type) {
        Trace maybeCurrentTrace = currentTrace.get();
        TraceState traceState = Tracer.getTraceState(maybeCurrentTrace, type);
        boolean sampled = maybeCurrentTrace != null ? maybeCurrentTrace.isObservable() : sampler.sample();
        Optional<String> parentSpan = Tracer.getParentSpanId(maybeCurrentTrace);
        return sampled ? new SampledDetachedSpan(operation, type, traceState, parentSpan) : new UnsampledDetachedSpan(traceState, Optional.empty());
    }

    static DetachedSpan detachInternal(Observability observability, String traceId, Optional<String> forUserAgent, Optional<String> parentSpanId, @Safe String operation, SpanType type) {
        Optional<String> requestId = type == SpanType.SERVER_INCOMING ? Optional.of(Tracers.randomId()) : Optional.empty();
        return Tracer.detachInternal(observability, traceId, requestId, forUserAgent, parentSpanId, operation, type);
    }

    static DetachedSpan detachInternal(Observability observability, String traceId, Optional<String> requestId, Optional<String> forUserAgent, Optional<String> parentSpanId, @Safe String operation, SpanType type) {
        TraceState traceState = TraceState.of(traceId, requestId, forUserAgent);
        return Tracer.shouldObserve(observability) ? new SampledDetachedSpan(operation, type, traceState, parentSpanId) : new UnsampledDetachedSpan(traceState, parentSpanId);
    }

    static Detached detachInternal() {
        Trace trace = currentTrace.get();
        if (trace == null) {
            return NopDetached.INSTANCE;
        }
        if (trace.isObservable()) {
            OpenSpan maybeOpenSpan = trace.top().orElse(null);
            if (maybeOpenSpan == null) {
                return NopDetached.INSTANCE;
            }
            return new SampledDetached(trace.getTraceState(), maybeOpenSpan);
        }
        return new UnsampledDetachedSpan(trace.getTraceState(), Optional.empty());
    }

    private static Optional<String> getParentSpanId(@Nullable Trace trace) {
        Optional<OpenSpan> maybeOpenSpan;
        if (trace != null && (maybeOpenSpan = trace.top()).isPresent()) {
            return Optional.of(maybeOpenSpan.get().getSpanId());
        }
        return Optional.empty();
    }

    @Nullable
    static TraceState getTraceState() {
        Trace maybeCurrentTrace = currentTrace.get();
        if (maybeCurrentTrace == null) {
            return null;
        }
        return maybeCurrentTrace.getTraceState();
    }

    private static TraceState getTraceState(@Nullable Trace maybeCurrentTrace, SpanType newSpanType) {
        if (maybeCurrentTrace != null) {
            return maybeCurrentTrace.getTraceState();
        }
        return TraceState.of(Tracers.randomId(), Tracer.getRequestIdForSpan(newSpanType), Optional.empty());
    }

    private static Optional<String> getRequestIdForSpan(SpanType newSpanType) {
        if (newSpanType == SpanType.SERVER_INCOMING) {
            return Optional.of(Tracers.randomId());
        }
        return Optional.empty();
    }

    @Nullable
    static String getRequestId(DetachedSpan detachedSpan) {
        if (detachedSpan instanceof SampledDetachedSpan) {
            return ((SampledDetachedSpan)detachedSpan).traceState.requestId();
        }
        if (detachedSpan instanceof UnsampledDetachedSpan) {
            return ((UnsampledDetachedSpan)detachedSpan).traceState.requestId();
        }
        throw new SafeIllegalStateException("Unknown span type", SafeArg.of("detachedSpan", detachedSpan));
    }

    static boolean isSampled(DetachedSpan detachedSpan) {
        return detachedSpan instanceof SampledDetachedSpan;
    }

    public static void fastCompleteSpan() {
        Tracer.fastCompleteSpan(NoTagTranslator.INSTANCE, NoTagTranslator.INSTANCE);
    }

    public static void fastCompleteSpan(@Safe Map<String, String> metadata) {
        Tracer.fastCompleteSpan(MapTagTranslator.INSTANCE, metadata);
    }

    public static <T> void fastCompleteSpan(TagTranslator<? super T> tag, T state) {
        Trace trace = currentTrace.get();
        if (trace != null) {
            Optional<OpenSpan> span = Tracer.popCurrentSpan(trace);
            if (trace.isObservable()) {
                Tracer.completeSpanAndNotifyObservers(span, tag, state, trace.getTraceId());
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Attempted to complete spans when there is no active Trace. This may be the result of calling completeSpan more times than startSpan", new SafeRuntimeException("not a real exception", new Arg[0]));
        }
    }

    private static <T> void completeSpanAndNotifyObservers(Optional<OpenSpan> openSpan, TagTranslator<? super T> tag, T state, String traceId) {
        if (openSpan.isPresent()) {
            Tracer.notifyObservers(Tracer.toSpan(openSpan.get(), tag, state, traceId));
        }
    }

    @CheckReturnValue
    public static Optional<Span> completeSpan() {
        return Tracer.completeSpan(Collections.emptyMap());
    }

    @CheckReturnValue
    @Deprecated
    public static Optional<Span> completeSpan(@Safe Map<String, String> metadata) {
        Trace trace = currentTrace.get();
        if (trace == null) {
            if (log.isDebugEnabled()) {
                log.debug("Attempted to complete spans when there is no active Trace. This may be the result of calling completeSpan more times than startSpan", new SafeRuntimeException("not a real exception", new Arg[0]));
            }
            return Optional.empty();
        }
        Optional<Span> maybeSpan = Tracer.popCurrentSpan(trace).map(openSpan -> Tracer.toSpan(openSpan, MapTagTranslator.INSTANCE, metadata, trace.getTraceId()));
        if (maybeSpan.isPresent() && trace.isObservable()) {
            Tracer.notifyObservers(maybeSpan.get());
        }
        return maybeSpan;
    }

    private static void notifyObservers(Span span) {
        compositeObserver.accept(span);
    }

    private static Optional<OpenSpan> popCurrentSpan(Trace trace) {
        Optional<OpenSpan> span = trace.pop();
        if (trace.isEmpty()) {
            Tracer.clearCurrentTrace();
        }
        return span;
    }

    private static <T> Span toSpan(OpenSpan openSpan, TagTranslator<? super T> translator, T state, String traceId) {
        Span.Builder builder = Span.builder().traceId(traceId).spanId(openSpan.getSpanId()).type(openSpan.type()).parentSpanId(openSpan.getParentSpanId()).operation(openSpan.getOperation()).startTimeMicroSeconds(openSpan.getStartTimeMicroSeconds()).durationNanoSeconds(System.nanoTime() - openSpan.getStartClockNanoSeconds());
        if (!translator.isEmpty((Span.Builder)state)) {
            translator.translate(SpanBuilderTagAdapter.INSTANCE, builder, (Span.Builder)state);
        }
        return builder.build();
    }

    public static synchronized SpanObserver subscribe(String name, SpanObserver observer) {
        if (observers.containsKey(name)) {
            log.warn("Overwriting existing SpanObserver with name {} by new observer: {}", SafeArg.of("name", name), UnsafeArg.of("observer", observer));
        }
        if (observers.size() >= 5) {
            log.warn("Five or more SpanObservers registered: {}", SafeArg.of("observers", observers.keySet()));
        }
        SpanObserver currentValue = observers.put(name, observer);
        Tracer.computeObserversList();
        return currentValue;
    }

    public static synchronized SpanObserver unsubscribe(String name) {
        SpanObserver removedObserver = observers.remove(name);
        Tracer.computeObserversList();
        return removedObserver;
    }

    private static void computeObserversList() {
        Consumer<Span> newCompositeObserver = _span -> {};
        for (Map.Entry<String, SpanObserver> entry : observers.entrySet()) {
            String observerName = entry.getKey();
            SpanObserver spanObserver = entry.getValue();
            newCompositeObserver = newCompositeObserver.andThen(span -> {
                try {
                    spanObserver.consume((Span)span);
                }
                catch (RuntimeException e) {
                    log.error("Failed to invoke observer {} registered as {}", SafeArg.of("observer", spanObserver), SafeArg.of("name", observerName), e);
                }
            });
        }
        compositeObserver = newCompositeObserver;
    }

    public static void setSampler(TraceSampler sampler) {
        Tracer.sampler = sampler;
    }

    public static boolean hasTraceId() {
        return currentTrace.get() != null;
    }

    public static String getTraceId() {
        return Preconditions.checkNotNull(currentTrace.get(), "There is no trace").getTraceId();
    }

    static Optional<String> getForUserAgent() {
        Trace trace = currentTrace.get();
        return trace == null ? Optional.empty() : trace.getForUserAgent();
    }

    @Nullable
    static String getForUserAgent(DetachedSpan detachedSpan) {
        if (detachedSpan instanceof SampledDetachedSpan) {
            return ((SampledDetachedSpan)detachedSpan).traceState.forUserAgent();
        }
        if (detachedSpan instanceof UnsampledDetachedSpan) {
            return ((UnsampledDetachedSpan)detachedSpan).traceState.forUserAgent();
        }
        throw new SafeIllegalStateException("Unknown span type", SafeArg.of("detachedSpan", detachedSpan));
    }

    static Optional<Trace> getAndClearTraceIfPresent() {
        Optional<Trace> trace = Optional.ofNullable(currentTrace.get());
        Tracer.clearCurrentTrace();
        return trace;
    }

    public static Trace getAndClearTrace() {
        Trace trace = Tracer.getOrCreateCurrentTrace();
        Tracer.clearCurrentTrace();
        return trace;
    }

    public static boolean isTraceObservable() {
        Trace trace = currentTrace.get();
        return trace != null && trace.isObservable();
    }

    public static boolean hasUnobservableTrace() {
        Trace trace = currentTrace.get();
        return trace != null && !trace.isObservable();
    }

    static Optional<Trace> copyTrace() {
        Trace trace = currentTrace.get();
        if (trace != null) {
            return Optional.of(trace.deepCopy());
        }
        return Optional.empty();
    }

    static void setTrace(Trace trace) {
        currentTrace.set(trace);
        MDC.put("traceId", trace.getTraceId());
        Tracer.setTraceSampledMdcIfObservable(trace.isObservable());
        Tracer.setTraceRequestId(trace.maybeGetRequestId());
        Tracer.logSettingTrace();
    }

    private static void setTraceSampledMdcIfObservable(boolean observable) {
        if (observable) {
            MDC.put("_sampled", "1");
        } else {
            MDC.remove("_sampled");
        }
    }

    private static void setTraceRequestId(@Nullable String requestId) {
        if (requestId == null) {
            MDC.remove("_requestId");
        } else {
            MDC.put("_requestId", requestId);
        }
    }

    private static void logSettingTrace() {
        log.debug("Setting trace");
    }

    private static Trace getOrCreateCurrentTrace() {
        Trace trace = currentTrace.get();
        if (trace == null) {
            trace = Tracer.createTrace(Observability.UNDECIDED, Tracers.randomId(), Optional.empty());
            Tracer.setTrace(trace);
        }
        return trace;
    }

    @VisibleForTesting
    static void clearCurrentTrace() {
        Tracer.logClearingTrace();
        currentTrace.set(null);
        MDC.remove("traceId");
        MDC.remove("_sampled");
        MDC.remove("_requestId");
    }

    private static void logClearingTrace() {
        if (log.isDebugEnabled()) {
            log.debug("Clearing current trace", SafeArg.of("trace", currentTrace.get()));
            if (log.isTraceEnabled()) {
                log.trace("Stacktrace at time of clearing trace", new SafeRuntimeException("not a real exception", new Arg[0]));
            }
        }
    }

    private static enum SpanBuilderTagAdapter implements TagTranslator.TagAdapter<Span.Builder>
    {
        INSTANCE;


        @Override
        public void tag(Span.Builder target, String key, String value) {
            if (key != null && value != null) {
                target.putMetadata(key, value);
            }
        }

        @Override
        public void tag(Span.Builder target, Map<String, String> tags) {
            target.putAllMetadata(tags);
        }
    }

    private static final class TraceRestoringCloseableSpan
    implements CloseableSpan {
        private final Trace original;

        TraceRestoringCloseableSpan(Trace original) {
            this.original = original;
        }

        @Override
        public void close() {
            Tracer.fastCompleteSpan();
            Tracer.setTrace(this.original);
        }
    }

    private static final class UnsampledDetachedSpan
    implements DetachedSpan {
        private final TraceState traceState;
        private final Optional<String> parentSpanId;

        UnsampledDetachedSpan(TraceState traceState, Optional<String> parentSpanId) {
            this.traceState = traceState;
            this.parentSpanId = parentSpanId;
        }

        @Override
        public <T> CloseableSpan childSpan(String operationName, TagTranslator<? super T> _translator, T _data, SpanType type) {
            Trace maybeCurrentTrace = currentTrace.get();
            Tracer.setTrace(Trace.of(false, this.traceState));
            if (this.parentSpanId.isPresent()) {
                Tracer.fastStartSpan(operationName, this.parentSpanId.get(), type);
            } else {
                Tracer.fastStartSpan(operationName, type);
            }
            return maybeCurrentTrace == null ? DEFAULT_CLOSEABLE_SPAN : new TraceRestoringCloseableSpan(maybeCurrentTrace);
        }

        @Override
        public DetachedSpan childDetachedSpan(String _operation, SpanType _type) {
            return this;
        }

        @Override
        @MustBeClosed
        public CloseableSpan attach() {
            return this.childSpan("SYNTHETIC_ATTACH");
        }

        @Override
        public void complete() {
        }

        @Override
        public <T> void complete(TagTranslator<? super T> _tag, T _state) {
        }

        public String toString() {
            return "UnsampledDetachedSpan{traceState=" + this.traceState + "}";
        }
    }

    private static final class SampledDetached
    implements Detached {
        private final TraceState traceState;
        private final OpenSpan openSpan;

        SampledDetached(TraceState traceState, OpenSpan openSpan) {
            this.traceState = traceState;
            this.openSpan = openSpan;
        }

        @Override
        @MustBeClosed
        public <T> CloseableSpan childSpan(String operationName, TagTranslator<? super T> translator, T data, SpanType type) {
            return SampledDetachedSpan.childSpan(this.traceState, this.openSpan, operationName, translator, data, type);
        }

        @Override
        public DetachedSpan childDetachedSpan(String operation, SpanType type) {
            return new SampledDetachedSpan(operation, type, this.traceState, Optional.of(this.openSpan.getSpanId()));
        }

        @Override
        @MustBeClosed
        public CloseableSpan attach() {
            return SampledDetachedSpan.attach(this.openSpan, this.traceState);
        }

        public String toString() {
            return "SampledDetached{traceState=" + this.traceState + ", openSpan=" + this.openSpan + "}";
        }
    }

    private static final class SampledDetachedSpan
    implements DetachedSpan {
        private static final int NOT_COMPLETE = 0;
        private static final int COMPLETE = 1;
        private static final AtomicIntegerFieldUpdater<SampledDetachedSpan> completedUpdater = AtomicIntegerFieldUpdater.newUpdater(SampledDetachedSpan.class, "completed");
        private final TraceState traceState;
        private final OpenSpan openSpan;
        private volatile int completed;

        SampledDetachedSpan(String operation, SpanType type, TraceState traceState, Optional<String> parentSpanId) {
            this.traceState = traceState;
            this.openSpan = OpenSpan.of(operation, Tracers.randomId(), type, parentSpanId);
        }

        @MustBeClosed
        private static <T> CloseableSpan childSpan(TraceState traceState, OpenSpan openSpan, String operationName, TagTranslator<? super T> translator, T data, SpanType type) {
            Trace maybeCurrentTrace = currentTrace.get();
            Tracer.setTrace(Trace.of(true, traceState));
            Tracer.fastStartSpan(operationName, openSpan.getSpanId(), type);
            return TraceRestoringCloseableSpanWithMetadata.of(maybeCurrentTrace, translator, data);
        }

        @Override
        @MustBeClosed
        public <T> CloseableSpan childSpan(String operationName, TagTranslator<? super T> translator, T data, SpanType type) {
            return SampledDetachedSpan.childSpan(this.traceState, this.openSpan, operationName, translator, data, type);
        }

        @Override
        public DetachedSpan childDetachedSpan(String operation, SpanType type) {
            return new SampledDetachedSpan(operation, type, this.traceState, Optional.of(this.openSpan.getSpanId()));
        }

        @MustBeClosed
        private static CloseableSpan attach(OpenSpan openSpan, TraceState traceState) {
            Trace maybeCurrentTrace = currentTrace.get();
            Trace newTrace = Trace.of(true, traceState);
            newTrace.push(openSpan);
            Tracer.setTrace(newTrace);
            return maybeCurrentTrace == null ? REMOVE_TRACE : () -> Tracer.setTrace(maybeCurrentTrace);
        }

        @Override
        @MustBeClosed
        public CloseableSpan attach() {
            return SampledDetachedSpan.attach(this.openSpan, this.traceState);
        }

        @Override
        public void complete() {
            this.complete(NoTagTranslator.INSTANCE, NoTagTranslator.INSTANCE);
        }

        @Override
        public <T> void complete(TagTranslator<? super T> tagTranslator, T data) {
            if (0 == completedUpdater.getAndSet(this, 1)) {
                Tracer.notifyObservers(Tracer.toSpan(this.openSpan, tagTranslator, data, this.traceState.traceId()));
            }
        }

        public String toString() {
            return "SampledDetachedSpan{completed=" + (this.completed == 1) + ", traceState=" + this.traceState + ", openSpan=" + this.openSpan + "}";
        }
    }

    private static final class TraceRestoringCloseableSpanWithMetadata<T>
    implements CloseableSpan {
        @Nullable
        private final Trace original;
        private final TagTranslator<? super T> translator;
        private final T data;

        static <T> CloseableSpan of(@Nullable Trace original, TagTranslator<? super T> translator, T data) {
            if (original != null || !translator.isEmpty(data)) {
                return new TraceRestoringCloseableSpanWithMetadata<T>(original, translator, data);
            }
            return DEFAULT_CLOSEABLE_SPAN;
        }

        TraceRestoringCloseableSpanWithMetadata(@Nullable Trace original, TagTranslator<? super T> translator, T data) {
            this.original = original;
            this.translator = translator;
            this.data = data;
        }

        @Override
        public void close() {
            Tracer.fastCompleteSpan(this.translator, this.data);
            Trace originalTrace = this.original;
            if (originalTrace != null) {
                Tracer.setTrace(originalTrace);
            }
        }
    }
}

