/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tracing;

import com.palantir.logsafe.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.util.concurrent.ListenableFuture;
import shadow.palantir.driver.com.google.common.util.concurrent.MoreExecutors;
import shadow.palantir.driver.com.palantir.tracing.CloseableSpan;
import shadow.palantir.driver.com.palantir.tracing.Detached;
import shadow.palantir.driver.com.palantir.tracing.DetachedSpan;
import shadow.palantir.driver.com.palantir.tracing.MapTagTranslator;
import shadow.palantir.driver.com.palantir.tracing.Observability;
import shadow.palantir.driver.com.palantir.tracing.Trace;
import shadow.palantir.driver.com.palantir.tracing.TraceMetadata;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.com.palantir.tracing.TracingHeadersEnrichingFunction;
import shadow.palantir.driver.com.palantir.tracing.WrappingExecutorService;
import shadow.palantir.driver.com.palantir.tracing.WrappingScheduledExecutorService;
import shadow.palantir.driver.com.palantir.tracing.api.SpanType;

public final class Tracers {
    public static final String TRACE_ID_KEY = "traceId";
    public static final String TRACE_SAMPLED_KEY = "_sampled";
    public static final String REQUEST_ID_KEY = "_requestId";
    private static final String DEFAULT_ROOT_SPAN_OPERATION = "root";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Tracers() {
    }

    public static String randomId() {
        return Tracers.longToPaddedHex(ThreadLocalRandom.current().nextLong());
    }

    static String longToPaddedHex(long number) {
        char[] data = new char[]{HEX_DIGITS[(int)(number >> 60 & 0xFL)], HEX_DIGITS[(int)(number >> 56 & 0xFL)], HEX_DIGITS[(int)(number >> 52 & 0xFL)], HEX_DIGITS[(int)(number >> 48 & 0xFL)], HEX_DIGITS[(int)(number >> 44 & 0xFL)], HEX_DIGITS[(int)(number >> 40 & 0xFL)], HEX_DIGITS[(int)(number >> 36 & 0xFL)], HEX_DIGITS[(int)(number >> 32 & 0xFL)], HEX_DIGITS[(int)(number >> 28 & 0xFL)], HEX_DIGITS[(int)(number >> 24 & 0xFL)], HEX_DIGITS[(int)(number >> 20 & 0xFL)], HEX_DIGITS[(int)(number >> 16 & 0xFL)], HEX_DIGITS[(int)(number >> 12 & 0xFL)], HEX_DIGITS[(int)(number >> 8 & 0xFL)], HEX_DIGITS[(int)(number >> 4 & 0xFL)], HEX_DIGITS[(int)(number >> 0 & 0xFL)]};
        return new String(data);
    }

    public static ExecutorService wrap(ExecutorService executorService) {
        return new WrappingExecutorService(executorService){

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Tracers.wrap(callable);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Tracers.wrap(command);
            }
        };
    }

    public static ExecutorService wrap(final String operation, ExecutorService executorService) {
        return new WrappingExecutorService(executorService){

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Tracers.wrap(operation, callable);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Tracers.wrap(operation, command);
            }
        };
    }

    public static ScheduledExecutorService wrap(ScheduledExecutorService executorService) {
        return new WrappingScheduledExecutorService(executorService){

            @Override
            protected Runnable wrapRecurring(Runnable runnable) {
                return Tracers.wrapWithNewTrace(runnable);
            }

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Tracers.wrap(callable);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Tracers.wrap(command);
            }
        };
    }

    public static ScheduledExecutorService wrap(final String operation, ScheduledExecutorService executorService) {
        return new WrappingScheduledExecutorService(executorService){

            @Override
            protected Runnable wrapRecurring(Runnable runnable) {
                return Tracers.wrapWithNewTrace(operation, runnable);
            }

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Tracers.wrap(operation, callable);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Tracers.wrap(operation, command);
            }
        };
    }

    public static <V> Callable<V> wrap(Callable<V> delegate) {
        return new AnonymousTracingAwareCallable<V>(delegate);
    }

    public static <V> Callable<V> wrap(String operation, Callable<V> delegate) {
        return new TracingAwareCallable<V>(operation, ImmutableMap.of(), delegate);
    }

    public static <V> Callable<V> wrap(String operation, Map<String, String> metadata, Callable<V> delegate) {
        return new TracingAwareCallable<V>(operation, metadata, delegate);
    }

    public static Runnable wrap(Runnable delegate) {
        return new AnonymousTracingAwareRunnable(delegate);
    }

    public static Runnable wrap(String operation, Runnable delegate) {
        return Tracers.wrap(operation, ImmutableMap.of(), delegate);
    }

    public static Runnable wrap(String operation, Map<String, String> metadata, Runnable delegate) {
        return new TracingAwareRunnable(operation, metadata, delegate);
    }

    public static <T, U extends ListenableFuture<T>> U wrapListenableFuture(String operation, Supplier<U> delegateFactory) {
        return Tracers.wrapListenableFuture(operation, ImmutableMap.of(), delegateFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U extends ListenableFuture<T>> U wrapListenableFuture(String operation, Map<String, String> metadata, Supplier<U> delegateFactory) {
        DetachedSpan span = DetachedSpan.start(operation);
        ListenableFuture result = null;
        try (CloseableSpan ignored = span.attach();){
            result = Preconditions.checkNotNull((ListenableFuture)delegateFactory.get(), "Expected a ListenableFuture");
        }
        finally {
            if (result != null) {
                result.addListener(new ListenableFutureSpanListener(span, metadata), MoreExecutors.directExecutor());
            } else {
                span.complete(MapTagTranslator.INSTANCE, metadata);
            }
        }
        return (U)result;
    }

    public static <T> void addTracingHeaders(T state, TracingHeadersEnrichingFunction<T> tracingHeadersEnrichingFunction) {
        Optional<TraceMetadata> maybeTraceMetadata = Tracer.maybeGetTraceMetadata();
        if (maybeTraceMetadata.isEmpty()) {
            return;
        }
        TraceMetadata traceMetadata = maybeTraceMetadata.get();
        tracingHeadersEnrichingFunction.addHeader("X-B3-TraceId", traceMetadata.getTraceId(), state);
        tracingHeadersEnrichingFunction.addHeader("X-B3-SpanId", traceMetadata.getSpanId(), state);
        tracingHeadersEnrichingFunction.addHeader("X-B3-Sampled", Tracer.isTraceObservable() ? "1" : "0", state);
        Optional<String> forUserAgent = Tracer.getForUserAgent();
        if (forUserAgent.isPresent()) {
            tracingHeadersEnrichingFunction.addHeader("For-User-Agent", forUserAgent.get(), state);
        }
    }

    @Deprecated
    public static ExecutorService wrapWithNewTrace(ExecutorService executorService) {
        return Tracers.wrapWithNewTrace(DEFAULT_ROOT_SPAN_OPERATION, executorService);
    }

    public static ExecutorService wrapWithNewTrace(final String operation, ExecutorService executorService) {
        return new WrappingExecutorService(executorService){

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Tracers.wrapWithNewTrace(operation, callable);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Tracers.wrapWithNewTrace(operation, command);
            }
        };
    }

    @Deprecated
    public static ScheduledExecutorService wrapWithNewTrace(ScheduledExecutorService executorService) {
        return Tracers.wrapWithNewTrace(DEFAULT_ROOT_SPAN_OPERATION, executorService);
    }

    public static ScheduledExecutorService wrapWithNewTrace(final String operation, ScheduledExecutorService executorService) {
        return new WrappingScheduledExecutorService(executorService){

            @Override
            protected Runnable wrapRecurring(Runnable runnable) {
                return this.wrapTask(runnable);
            }

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Tracers.wrapWithNewTrace(operation, callable);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Tracers.wrapWithNewTrace(operation, command);
            }
        };
    }

    @Deprecated
    public static <V> Callable<V> wrapWithNewTrace(Callable<V> delegate) {
        return Tracers.wrapWithNewTrace(DEFAULT_ROOT_SPAN_OPERATION, delegate);
    }

    public static <V> Callable<V> wrapWithNewTrace(String operation, Callable<V> delegate) {
        return Tracers.wrapWithNewTrace(operation, Observability.UNDECIDED, delegate);
    }

    public static <V> Callable<V> wrapWithNewTrace(String operation, Observability observability, Callable<V> delegate) {
        return () -> {
            Optional<Trace> originalTrace = Tracer.getAndClearTraceIfPresent();
            try {
                Tracer.initTraceWithSpan(observability, Tracers.randomId(), operation, SpanType.LOCAL);
                Object v = delegate.call();
                return v;
            }
            finally {
                Tracer.fastCompleteSpan();
                Tracers.restoreTrace(originalTrace);
            }
        };
    }

    @Deprecated
    public static Runnable wrapWithNewTrace(Runnable delegate) {
        return Tracers.wrapWithNewTrace(DEFAULT_ROOT_SPAN_OPERATION, delegate);
    }

    public static Runnable wrapWithNewTrace(String operation, Runnable delegate) {
        return Tracers.wrapWithNewTrace(operation, Observability.UNDECIDED, delegate);
    }

    public static Runnable wrapWithNewTrace(String operation, Observability observability, Runnable delegate) {
        return () -> {
            Optional<Trace> originalTrace = Tracer.getAndClearTraceIfPresent();
            try {
                Tracer.initTraceWithSpan(observability, Tracers.randomId(), operation, SpanType.LOCAL);
                delegate.run();
            }
            finally {
                Tracer.fastCompleteSpan();
                Tracers.restoreTrace(originalTrace);
            }
        };
    }

    public static <V> Callable<V> wrapWithAlternateTraceId(String traceId, String operation, Observability observability, Callable<V> delegate) {
        return () -> {
            Optional<Trace> originalTrace = Tracer.getAndClearTraceIfPresent();
            try {
                Tracer.initTraceWithSpan(observability, traceId, operation, SpanType.LOCAL);
                Object v = delegate.call();
                return v;
            }
            finally {
                Tracer.fastCompleteSpan();
                Tracers.restoreTrace(originalTrace);
            }
        };
    }

    @Deprecated
    public static Runnable wrapWithAlternateTraceId(String traceId, Runnable delegate) {
        return Tracers.wrapWithAlternateTraceId(traceId, DEFAULT_ROOT_SPAN_OPERATION, delegate);
    }

    public static Runnable wrapWithAlternateTraceId(String traceId, String operation, Runnable delegate) {
        return Tracers.wrapWithAlternateTraceId(traceId, operation, Observability.UNDECIDED, delegate);
    }

    public static Runnable wrapWithAlternateTraceId(String traceId, String operation, Observability observability, Runnable delegate) {
        return () -> {
            Optional<Trace> originalTrace = Tracer.getAndClearTraceIfPresent();
            try {
                Tracer.initTraceWithSpan(observability, traceId, operation, SpanType.LOCAL);
                delegate.run();
            }
            finally {
                Tracer.fastCompleteSpan();
                Tracers.restoreTrace(originalTrace);
            }
        };
    }

    private static void restoreTrace(Optional<Trace> trace) {
        if (trace.isPresent()) {
            Tracer.setTrace(trace.get());
        } else {
            Tracer.getAndClearTraceIfPresent();
        }
    }

    public static interface ThrowingCallable<T, E extends Throwable> {
        public T call() throws E;
    }

    private static class AnonymousTracingAwareRunnable
    implements Runnable {
        private final Runnable delegate;
        private final Detached detached;

        AnonymousTracingAwareRunnable(Runnable delegate) {
            this.delegate = delegate;
            this.detached = DetachedSpan.detach();
        }

        @Override
        public void run() {
            try (CloseableSpan ignored = this.detached.attach();){
                this.delegate.run();
            }
        }
    }

    private static class TracingAwareRunnable
    implements Runnable {
        private final Runnable delegate;
        private final Detached detached;
        private final String operation;
        private final Map<String, String> metadata;

        TracingAwareRunnable(String operation, Map<String, String> metadata, Runnable delegate) {
            this.delegate = delegate;
            this.detached = DetachedSpan.detach();
            this.operation = operation;
            this.metadata = metadata;
        }

        @Override
        public void run() {
            try (CloseableSpan ignored = this.detached.childSpan(this.operation, this.metadata);){
                this.delegate.run();
            }
        }
    }

    private static class AnonymousTracingAwareCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final Detached detached;

        AnonymousTracingAwareCallable(Callable<V> delegate) {
            this.delegate = delegate;
            this.detached = DetachedSpan.detach();
        }

        @Override
        public V call() throws Exception {
            try (CloseableSpan ignored = this.detached.attach();){
                V v = this.delegate.call();
                return v;
            }
        }
    }

    private static class TracingAwareCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final Detached detached;
        private final String operation;
        private final Map<String, String> metadata;

        TracingAwareCallable(String operation, Map<String, String> metadata, Callable<V> delegate) {
            this.delegate = delegate;
            this.detached = DetachedSpan.detach();
            this.operation = operation;
            this.metadata = metadata;
        }

        @Override
        public V call() throws Exception {
            try (CloseableSpan ignored = this.detached.childSpan(this.operation, this.metadata);){
                V v = this.delegate.call();
                return v;
            }
        }
    }

    private static final class ListenableFutureSpanListener
    implements Runnable {
        private final DetachedSpan span;
        private final Map<String, String> metadata;

        ListenableFutureSpanListener(DetachedSpan span, Map<String, String> metadata) {
            this.span = span;
            this.metadata = metadata;
        }

        @Override
        public void run() {
            this.span.complete(MapTagTranslator.INSTANCE, this.metadata);
        }

        public String toString() {
            return "ListenableFutureSpanListener{span=" + this.span + ", metadata=" + this.metadata + "}";
        }
    }
}

