/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.codahale.metrics.Metric;
import shadow.palantir.driver.com.codahale.metrics.MetricSet;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.Supplier;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.cache.Cache;
import shadow.palantir.driver.com.google.common.cache.CacheStats;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.tritium.metrics.InternalCacheMetrics;

final class CacheMetricSet
implements MetricSet {
    private final Cache<?, ?> cache;
    private final String cacheName;

    private CacheMetricSet(Cache<?, ?> cache, String cacheName) {
        this.cache = Preconditions.checkNotNull(cache, "cache");
        this.cacheName = Preconditions.checkNotNull(cacheName, "cacheName");
        Preconditions.checkArgument(!cacheName.trim().isEmpty(), "Cache name cannot be blank or empty");
    }

    static CacheMetricSet create(Cache<?, ?> cache, String cacheName) {
        return new CacheMetricSet(cache, cacheName);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return ImmutableMap.copyOf(InternalCacheMetrics.createMetrics(GuavaStats.create(this.cache, 1L, TimeUnit.SECONDS), metricName -> this.cacheName + "." + metricName));
    }

    static class GuavaStats
    implements InternalCacheMetrics.Stats {
        private final Cache<?, ?> cache;
        private final java.util.function.Supplier<CacheStats> stats;

        @VisibleForTesting
        GuavaStats(Cache<?, ?> cache, java.util.function.Supplier<CacheStats> stats) {
            this.cache = cache;
            this.stats = stats;
        }

        static InternalCacheMetrics.Stats create(Cache<?, ?> cache, long duration, TimeUnit timeUnit) {
            Supplier<CacheStats> statsSupplier = Suppliers.memoizeWithExpiration(cache::stats, duration, timeUnit);
            return new GuavaStats(cache, statsSupplier);
        }

        private CacheStats stats() {
            return this.stats.get();
        }

        @Override
        public Gauge<Long> estimatedSize() {
            return this.cache::size;
        }

        @Override
        public Optional<Gauge<Long>> weightedSize() {
            return Optional.empty();
        }

        @Override
        public Optional<Gauge<Long>> maximumSize() {
            return Optional.empty();
        }

        @Override
        public Gauge<Long> requestCount() {
            return () -> this.stats().requestCount();
        }

        @Override
        public Gauge<Long> hitCount() {
            return () -> this.stats().hitCount();
        }

        @Override
        public Gauge<Long> missCount() {
            return () -> this.stats().missCount();
        }

        @Override
        public Gauge<Long> evictionCount() {
            return () -> this.stats().evictionCount();
        }

        @Override
        public Gauge<Long> loadSuccessCount() {
            return () -> this.stats().loadSuccessCount();
        }

        @Override
        public Gauge<Long> loadFailureCount() {
            return () -> this.stats().loadExceptionCount();
        }

        @Override
        public Gauge<Double> loadAverageMillis() {
            return () -> this.stats().averageLoadPenalty() / 1000000.0;
        }
    }
}

