/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.google.common.cache.Cache;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.tritium.metrics.CacheMetricSet;
import shadow.palantir.driver.com.palantir.tritium.metrics.InternalCacheMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;

final class CacheTaggedMetrics {
    private final Cache<?, ?> cache;
    private final String cacheName;

    private CacheTaggedMetrics(Cache<?, ?> cache, @Safe String cacheName) {
        String name = Preconditions.checkNotNull(cacheName, "cacheName").trim();
        Preconditions.checkArgument(!name.isEmpty(), "Cache name cannot be blank or empty");
        this.cache = Preconditions.checkNotNull(cache, "cache");
        this.cacheName = name;
    }

    static CacheTaggedMetrics create(Cache<?, ?> cache, @Safe String cacheName) {
        return new CacheTaggedMetrics(cache, cacheName);
    }

    ImmutableMap<MetricName, Gauge<?>> getMetrics() {
        return InternalCacheMetrics.createMetrics(CacheMetricSet.GuavaStats.create(this.cache, 1L, TimeUnit.SECONDS), InternalCacheMetrics.taggedMetricName(this.cacheName));
    }
}

