/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import shadow.palantir.driver.com.google.common.base.CharMatcher;
import shadow.palantir.driver.com.palantir.tritium.metrics.JvmGcMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class GarbageCollectorMetrics {
    static void register(TaggedMetricRegistry metrics) {
        JvmGcMetrics gcMetrics = JvmGcMetrics.of(metrics);
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            String collector = GarbageCollectorMetrics.canonicalName(gc.getName());
            gcMetrics.count().collector(collector).build(gc::getCollectionCount);
            gcMetrics.time().collector(collector).build(gc::getCollectionTime);
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        gcMetrics.finalizerQueueSize(memoryBean::getObjectPendingFinalizationCount);
    }

    private static String canonicalName(String collectorName) {
        return CharMatcher.whitespace().replaceFrom((CharSequence)collectorName, "-");
    }

    private GarbageCollectorMetrics() {
    }
}

