/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import shadow.palantir.driver.com.palantir.tritium.event.InstrumentationProperties;
import shadow.palantir.driver.com.palantir.tritium.metrics.TlsMetrics;

final class HandshakeInstrumentation {
    private static final SafeLogger log = SafeLoggerFactory.get(HandshakeInstrumentation.class);

    static void record(TlsMetrics metrics, String contextName, String cipherSuite, String protocol) {
        metrics.handshake().context(contextName).cipher(cipherSuite).protocol(protocol).build().mark();
        if (log.isDebugEnabled()) {
            log.debug("TLS Handshake completed for context {}, cipher {}, protocol {}", SafeArg.of("context", contextName), SafeArg.of("cipherSuite", cipherSuite), SafeArg.of("protocol", protocol));
        }
    }

    static boolean isSocketInstrumentationEnabled() {
        return log.isDebugEnabled() || InstrumentationProperties.isSpecificEnabled("tls.socket", false);
    }

    private HandshakeInstrumentation() {
    }
}

