/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import shadow.palantir.driver.com.palantir.tritium.metrics.HandshakeInstrumentation;
import shadow.palantir.driver.com.palantir.tritium.metrics.TlsMetrics;
import shadow.palantir.driver.javax.annotation.Nullable;

final class InstrumentedSslEngine
extends SSLEngine {
    private static final SafeLogger log = SafeLoggerFactory.get(InstrumentedSslEngine.class);
    private final AtomicBoolean handshaking = new AtomicBoolean(true);
    private final SSLEngine engine;
    private final TlsMetrics metrics;
    private final String name;

    static SSLEngine instrument(SSLEngine engine, TlsMetrics metrics, String name) {
        return new InstrumentedSslEngine(engine, metrics, name);
    }

    static SSLEngine extractDelegate(SSLEngine maybeInstrumented) {
        SSLEngine current = maybeInstrumented;
        while (current instanceof InstrumentedSslEngine) {
            current = ((InstrumentedSslEngine)current).engine;
        }
        return current;
    }

    private InstrumentedSslEngine(SSLEngine engine, TlsMetrics metrics, String name) {
        this.engine = engine;
        this.metrics = metrics;
        this.name = name;
    }

    @Override
    public String getPeerHost() {
        return this.engine.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.engine.getPeerPort();
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.check(this.engine.wrap(src, dst));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] sources, ByteBuffer byteBuffer) throws SSLException {
        return this.check(this.engine.wrap(sources, byteBuffer));
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer[] sources, int offset, int length, ByteBuffer dest) throws SSLException {
        return this.check(this.engine.wrap(sources, offset, length, dest));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this.check(this.engine.unwrap(src, dst));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBuffers) throws SSLException {
        return this.check(this.engine.unwrap(byteBuffer, byteBuffers));
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        return this.check(this.engine.unwrap(src, dsts, offset, length));
    }

    @Override
    public Runnable getDelegatedTask() {
        return this.engine.getDelegatedTask();
    }

    @Override
    public void closeInbound() throws SSLException {
        this.engine.closeInbound();
    }

    @Override
    public boolean isInboundDone() {
        return this.engine.isInboundDone();
    }

    @Override
    public void closeOutbound() {
        this.engine.closeOutbound();
    }

    @Override
    public boolean isOutboundDone() {
        return this.engine.isOutboundDone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.engine.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.engine.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] strings) {
        this.engine.setEnabledCipherSuites(strings);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.engine.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.engine.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] strings) {
        this.engine.setEnabledProtocols(strings);
    }

    @Override
    public SSLSession getSession() {
        return this.engine.getSession();
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.engine.getHandshakeSession();
    }

    @Override
    public void beginHandshake() throws SSLException {
        this.engine.beginHandshake();
        this.handshaking.set(true);
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.engine.getHandshakeStatus();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.engine.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.engine.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.engine.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.engine.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.engine.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters sslParameters) {
        this.engine.setSSLParameters(sslParameters);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", delegate=" + this.engine + "}";
    }

    @Override
    public String getApplicationProtocol() {
        return this.engine.getApplicationProtocol();
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return this.engine.getHandshakeApplicationProtocol();
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) {
        this.engine.setHandshakeApplicationProtocolSelector(selector);
    }

    @Override
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return this.engine.getHandshakeApplicationProtocolSelector();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof InstrumentedSslEngine) {
            InstrumentedSslEngine that = (InstrumentedSslEngine)other;
            return this.engine.equals(that.engine) && this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.engine, this.name);
    }

    private SSLEngineResult check(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.handshaking.compareAndSet(true, false)) {
            try {
                SSLSession session = this.engine.getSession();
                if (session != null) {
                    HandshakeInstrumentation.record(this.metrics, this.name, session.getCipherSuite(), session.getProtocol());
                }
            }
            catch (RuntimeException e) {
                log.warn("Failed to record handshake metrics", e);
            }
        }
        return result;
    }
}

