/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.Objects;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import shadow.palantir.driver.com.palantir.tritium.metrics.HandshakeInstrumentation;
import shadow.palantir.driver.com.palantir.tritium.metrics.InstrumentedSslSocketFactory;
import shadow.palantir.driver.com.palantir.tritium.metrics.TlsMetrics;
import shadow.palantir.driver.javax.annotation.Nullable;

final class InstrumentedSslServerSocketFactory
extends SSLServerSocketFactory {
    private final String name;
    private final SSLServerSocketFactory delegate;
    private final HandshakeCompletedListener listener;

    InstrumentedSslServerSocketFactory(SSLServerSocketFactory delegate, TlsMetrics metrics, String name) {
        this.delegate = delegate;
        this.name = name;
        this.listener = InstrumentedSslSocketFactory.newHandshakeListener(metrics, name);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.wrap(this.delegate.createServerSocket(port));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.wrap(this.delegate.createServerSocket(port, backlog));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress inetAddress) throws IOException {
        return this.wrap(this.delegate.createServerSocket(port, backlog, inetAddress));
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.wrap(this.delegate.createServerSocket());
    }

    public String toString() {
        return "InstrumentedSSLServerSocketFactory{delegate=" + this.delegate + "}";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InstrumentedSslServerSocketFactory that = (InstrumentedSslServerSocketFactory)other;
        return this.name.equals(that.name) && this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delegate);
    }

    private ServerSocket wrap(ServerSocket serverSocket) throws IOException {
        if (serverSocket instanceof SSLServerSocket) {
            return new InstrumentedServerSocket((SSLServerSocket)serverSocket, this.listener);
        }
        return serverSocket;
    }

    private static final class InstrumentedServerSocket
    extends SSLServerSocket {
        private final SSLServerSocket delegate;
        private final HandshakeCompletedListener listener;

        InstrumentedServerSocket(SSLServerSocket delegate, HandshakeCompletedListener listener) throws IOException {
            this.delegate = delegate;
            this.listener = listener;
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.delegate.getEnabledCipherSuites();
        }

        @Override
        public void setEnabledCipherSuites(String[] strings) {
            this.delegate.setEnabledCipherSuites(strings);
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public String[] getSupportedProtocols() {
            return this.delegate.getSupportedProtocols();
        }

        @Override
        public String[] getEnabledProtocols() {
            return this.delegate.getEnabledProtocols();
        }

        @Override
        public void setEnabledProtocols(String[] strings) {
            this.delegate.setEnabledProtocols(strings);
        }

        @Override
        public void setNeedClientAuth(boolean need) {
            this.delegate.setNeedClientAuth(need);
        }

        @Override
        public boolean getNeedClientAuth() {
            return this.delegate.getNeedClientAuth();
        }

        @Override
        public void setWantClientAuth(boolean want) {
            this.delegate.setWantClientAuth(want);
        }

        @Override
        public boolean getWantClientAuth() {
            return this.delegate.getWantClientAuth();
        }

        @Override
        public void setUseClientMode(boolean flag) {
            this.delegate.setUseClientMode(flag);
        }

        @Override
        public boolean getUseClientMode() {
            return this.delegate.getUseClientMode();
        }

        @Override
        public void setEnableSessionCreation(boolean flag) {
            this.delegate.setEnableSessionCreation(flag);
        }

        @Override
        public boolean getEnableSessionCreation() {
            return this.delegate.getEnableSessionCreation();
        }

        @Override
        public SSLParameters getSSLParameters() {
            return this.delegate.getSSLParameters();
        }

        @Override
        public void setSSLParameters(SSLParameters sslParameters) {
            this.delegate.setSSLParameters(sslParameters);
        }

        @Override
        public void bind(SocketAddress endpoint) throws IOException {
            this.delegate.bind(endpoint);
        }

        @Override
        public void bind(SocketAddress endpoint, int backlog) throws IOException {
            this.delegate.bind(endpoint, backlog);
        }

        @Override
        public InetAddress getInetAddress() {
            return this.delegate.getInetAddress();
        }

        @Override
        public int getLocalPort() {
            return this.delegate.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.delegate.getLocalSocketAddress();
        }

        @Override
        public Socket accept() throws IOException {
            return this.wrap(this.delegate.accept());
        }

        private Socket wrap(Socket socket) {
            if (socket instanceof SSLSocket && HandshakeInstrumentation.isSocketInstrumentationEnabled()) {
                ((SSLSocket)socket).addHandshakeCompletedListener(this.listener);
            }
            return socket;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public ServerSocketChannel getChannel() {
            return this.delegate.getChannel();
        }

        @Override
        public boolean isBound() {
            return this.delegate.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.delegate.setSoTimeout(timeout);
        }

        @Override
        public int getSoTimeout() throws IOException {
            return this.delegate.getSoTimeout();
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.delegate.setReuseAddress(on);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.delegate.getReuseAddress();
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.delegate.setReceiveBufferSize(size);
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.delegate.getReceiveBufferSize();
        }

        @Override
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        @Override
        public String toString() {
            return "InstrumentedServerSocket{delegate=" + this.delegate + "}";
        }
    }
}

