/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.codahale.metrics.RatioGauge;
import shadow.palantir.driver.com.google.common.annotations.Beta;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;

@Beta
public final class InternalCacheMetrics {
    private InternalCacheMetrics() {
    }

    public static <K> ImmutableMap<K, Gauge<?>> createMetrics(Stats stats, Function<String, K> metricNamer) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize(12);
        stats.forEach((name, gauge) -> builder.put(metricNamer.apply((String)name), gauge));
        return builder.buildOrThrow();
    }

    public static Function<String, MetricName> taggedMetricName(String cacheName) {
        return name -> MetricName.builder().safeName((String)name).putSafeTags("cache", cacheName).build();
    }

    public static interface Stats {
        default public void forEach(BiConsumer<String, Gauge<?>> consumer) {
            consumer.accept("cache.estimated.size", this.estimatedSize());
            consumer.accept("cache.request.count", this.requestCount());
            consumer.accept("cache.hit.count", this.hitCount());
            consumer.accept("cache.hit.ratio", this.hitRatio());
            consumer.accept("cache.miss.count", this.missCount());
            consumer.accept("cache.miss.ratio", this.missRatio());
            consumer.accept("cache.eviction.count", this.evictionCount());
            consumer.accept("cache.load.success.count", this.loadSuccessCount());
            consumer.accept("cache.load.failure.count", this.loadFailureCount());
            consumer.accept("cache.load.average.millis", this.loadAverageMillis());
            this.maximumSize().ifPresent(maximumSizeGauge -> consumer.accept("cache.maximum.size", (Gauge<?>)maximumSizeGauge));
            this.weightedSize().ifPresent(weightedSizeGauge -> consumer.accept("cache.weighted.size", (Gauge<?>)weightedSizeGauge));
        }

        public Gauge<Long> estimatedSize();

        public Optional<Gauge<Long>> weightedSize();

        public Optional<Gauge<Long>> maximumSize();

        public Gauge<Long> requestCount();

        public Gauge<Long> hitCount();

        public Gauge<Long> missCount();

        public Gauge<Long> evictionCount();

        public Gauge<Long> loadSuccessCount();

        public Gauge<Long> loadFailureCount();

        public Gauge<Double> loadAverageMillis();

        default public Gauge<Double> hitRatio() {
            return new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(this.hitCount().getValue().doubleValue(), this.requestCount().getValue().doubleValue());
                }
            };
        }

        default public Gauge<Double> missRatio() {
            return new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of(this.missCount().getValue().doubleValue(), this.requestCount().getValue().doubleValue());
                }
            };
        }
    }
}

