/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class JvmGcMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.93.0";
    private static final MetricName finalizerQueueSizeMetricName = MetricName.builder().safeName("jvm.gc.finalizer.queue.size").putSafeTags("libraryName", "tritium").putSafeTags("libraryVersion", "0.93.0").putSafeTags("javaVersion", JAVA_VERSION).build();
    private final TaggedMetricRegistry registry;

    private JvmGcMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static JvmGcMetrics of(TaggedMetricRegistry registry) {
        return new JvmGcMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    CountBuilderCollectorStage count() {
        return new CountBuilder();
    }

    @CheckReturnValue
    TimeBuilderCollectorStage time() {
        return new TimeBuilder();
    }

    void finalizerQueueSize(Gauge<? extends Number> gauge) {
        this.registry.registerWithReplacement(JvmGcMetrics.finalizerQueueSizeMetricName(), gauge);
    }

    static MetricName finalizerQueueSizeMetricName() {
        return finalizerQueueSizeMetricName;
    }

    public String toString() {
        return "JvmGcMetrics{registry=" + this.registry + "}";
    }

    private final class TimeBuilder
    implements TimeBuilderCollectorStage,
    TimeBuildStage {
        private String collector;

        private TimeBuilder() {
        }

        @Override
        public TimeBuilder collector(@Safe String collector) {
            Preconditions.checkState(this.collector == null, "collector is already set");
            this.collector = Preconditions.checkNotNull(collector, "collector is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmGcMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.gc.time").putSafeTags("collector", this.collector).putSafeTags("libraryName", JvmGcMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmGcMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface TimeBuilderCollectorStage {
        @CheckReturnValue
        public TimeBuildStage collector(@Safe String var1);
    }

    static interface TimeBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    private final class CountBuilder
    implements CountBuilderCollectorStage,
    CountBuildStage {
        private String collector;

        private CountBuilder() {
        }

        @Override
        public CountBuilder collector(@Safe String collector) {
            Preconditions.checkState(this.collector == null, "collector is already set");
            this.collector = Preconditions.checkNotNull(collector, "collector is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmGcMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.gc.count").putSafeTags("collector", this.collector).putSafeTags("libraryName", JvmGcMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmGcMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface CountBuilderCollectorStage {
        @CheckReturnValue
        public CountBuildStage collector(@Safe String var1);
    }

    static interface CountBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

