/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import shadow.palantir.driver.com.codahale.metrics.RatioGauge;
import shadow.palantir.driver.com.google.common.base.CharMatcher;
import shadow.palantir.driver.com.palantir.tritium.metrics.JvmMemoryPoolsMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class MemoryPoolMetrics {
    static void register(TaggedMetricRegistry registry) {
        JvmMemoryPoolsMetrics metrics = JvmMemoryPoolsMetrics.of(registry);
        for (final MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            String poolName = MemoryPoolMetrics.canonicalName(memoryPool.getName());
            metrics.max().memoryPool(poolName).build(() -> memoryPool.getUsage().getMax());
            metrics.used().memoryPool(poolName).build(() -> memoryPool.getUsage().getUsed());
            metrics.committed().memoryPool(poolName).build(() -> memoryPool.getUsage().getCommitted());
            metrics.init().memoryPool(poolName).build(() -> memoryPool.getUsage().getInit());
            metrics.usage().memoryPool(poolName).build(new RatioGauge(){

                @Override
                protected RatioGauge.Ratio getRatio() {
                    MemoryUsage memoryUsage = memoryPool.getUsage();
                    double maximum = memoryUsage.getMax() == -1L ? (double)memoryUsage.getCommitted() : (double)memoryUsage.getMax();
                    return RatioGauge.Ratio.of(memoryUsage.getUsed(), maximum);
                }
            });
            if (memoryPool.getCollectionUsage() == null) continue;
            metrics.usedAfterGc().memoryPool(poolName).build(() -> memoryPool.getCollectionUsage().getUsed());
        }
    }

    private static String canonicalName(String collectorName) {
        return CharMatcher.whitespace().replaceFrom((CharSequence)collectorName, "-");
    }

    private MemoryPoolMetrics() {
    }
}

