/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import shadow.palantir.driver.com.codahale.metrics.Clock;
import shadow.palantir.driver.com.codahale.metrics.Counter;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.codahale.metrics.Histogram;
import shadow.palantir.driver.com.codahale.metrics.LockFreeExponentiallyDecayingReservoir;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.codahale.metrics.Metric;
import shadow.palantir.driver.com.codahale.metrics.MetricFilter;
import shadow.palantir.driver.com.codahale.metrics.MetricRegistry;
import shadow.palantir.driver.com.codahale.metrics.MetricSet;
import shadow.palantir.driver.com.codahale.metrics.Reservoir;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.base.Strings;
import shadow.palantir.driver.com.google.common.cache.Cache;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.CacheMetricSet;
import shadow.palantir.driver.com.palantir.tritium.metrics.CacheTaggedMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.ExecutorMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.GarbageCollectorMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.InstrumentedSslContext;
import shadow.palantir.driver.com.palantir.tritium.metrics.InstrumentedSslEngine;
import shadow.palantir.driver.com.palantir.tritium.metrics.InstrumentedSslSocketFactory;
import shadow.palantir.driver.com.palantir.tritium.metrics.MemoryPoolMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.MetricBuilder;
import shadow.palantir.driver.com.palantir.tritium.metrics.MetricRegistryWithReservoirs;
import shadow.palantir.driver.com.palantir.tritium.metrics.Reservoirs;
import shadow.palantir.driver.com.palantir.tritium.metrics.TaggedMetricsExecutorService;
import shadow.palantir.driver.com.palantir.tritium.metrics.TaggedMetricsScheduledExecutorService;
import shadow.palantir.driver.com.palantir.tritium.metrics.TaggedMetricsThreadFactory;
import shadow.palantir.driver.com.palantir.tritium.metrics.TlsMetrics;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class MetricRegistries {
    private static final SafeLogger log = SafeLoggerFactory.get(MetricRegistries.class);
    static final String RESERVOIR_TYPE_METRIC_NAME = MetricRegistry.name(MetricRegistries.class, "reservoir.type");

    private MetricRegistries() {
    }

    public static MetricRegistry createWithHdrHistogramReservoirs() {
        return MetricRegistries.createWithReservoirType(Reservoirs::hdrHistogramReservoir);
    }

    public static MetricRegistry createWithSlidingTimeWindowReservoirs(long window, TimeUnit windowUnit) {
        return MetricRegistries.createWithReservoirType(() -> Reservoirs.slidingTimeWindowArrayReservoir(window, windowUnit));
    }

    public static MetricRegistry createWithLockFreeExponentiallyDecayingReservoirs() {
        return MetricRegistries.createWithReservoirType(() -> LockFreeExponentiallyDecayingReservoir.builder().build());
    }

    @VisibleForTesting
    static MetricRegistry createWithReservoirType(Supplier<Reservoir> reservoirSupplier) {
        MetricRegistryWithReservoirs metrics = new MetricRegistryWithReservoirs(reservoirSupplier);
        String name = reservoirSupplier.get().getClass().getCanonicalName();
        MetricRegistries.registerSafe(metrics, RESERVOIR_TYPE_METRIC_NAME, () -> name);
        MetricRegistries.registerDefaultMetrics(metrics);
        return metrics;
    }

    private static void registerDefaultMetrics(MetricRegistry metrics) {
        MetricRegistries.registerSafe(metrics, MetricRegistry.name(MetricRegistries.class.getPackage().getName(), "snapshot", "begin"), new Gauge<String>(){
            private final String start = MetricRegistries.nowIsoTimestamp();

            @Override
            public String getValue() {
                return this.start;
            }
        });
        MetricRegistries.registerSafe(metrics, MetricRegistry.name(MetricRegistries.class.getPackage().getName(), "snapshot", "now"), MetricRegistries::nowIsoTimestamp);
    }

    @VisibleForTesting
    static String nowIsoTimestamp() {
        return DateTimeFormatter.ISO_ZONED_DATE_TIME.format(ZonedDateTime.now(ZoneOffset.UTC));
    }

    static <T extends Metric> T getOrAdd(MetricRegistry metrics, @Safe String name, MetricBuilder<T> builder) {
        Metric existingMetric = MetricRegistries.tryGetExistingMetric(metrics, name);
        if (existingMetric == null) {
            return MetricRegistries.addMetric(metrics, name, builder);
        }
        return MetricRegistries.getAndCheckExistingMetric(name, builder, existingMetric);
    }

    @Nullable
    private static Metric tryGetExistingMetric(MetricRegistry metrics, @Safe String name) {
        return Preconditions.checkNotNull(metrics, "metrics").getMetrics().get(Preconditions.checkNotNull(name));
    }

    private static <T extends Metric> T addMetric(MetricRegistry metrics, @Safe String name, MetricBuilder<T> builder) {
        Preconditions.checkNotNull(builder);
        T newMetric = builder.newMetric();
        try {
            return metrics.register(name, newMetric);
        }
        catch (IllegalArgumentException e) {
            Metric existingMetric = metrics.getMetrics().get(name);
            return MetricRegistries.getAndCheckExistingMetric(name, builder, existingMetric);
        }
    }

    private static <T extends Metric> T getAndCheckExistingMetric(@Safe String name, MetricBuilder<T> builder, @Nullable Metric existingMetric) {
        if (existingMetric != null && builder.isInstance(existingMetric)) {
            return (T)existingMetric;
        }
        throw MetricRegistries.invalidMetric(name, existingMetric, builder.newMetric());
    }

    private static SafeIllegalArgumentException invalidMetric(@Safe String name, @Nullable Metric existingMetric, Metric newMetric) {
        throw new SafeIllegalArgumentException("Metric name already used for different metric type", SafeArg.of("metricName", name), SafeArg.of("existingMetricType", MetricRegistries.safeClassName(existingMetric)), SafeArg.of("newMetricType", MetricRegistries.safeClassName(newMetric)));
    }

    @Safe
    private static String safeClassName(@Nullable Object obj) {
        return obj == null ? "" : obj.getClass().getName();
    }

    public static MetricFilter metricsPrefixedBy(@Safe String prefix) {
        Preconditions.checkNotNull(prefix, "prefix");
        return (name, _metric) -> name.startsWith(prefix);
    }

    public static SortedMap<String, Metric> metricsMatching(MetricRegistry metrics, MetricFilter filter) {
        TreeMap<String, Metric> matchingMetrics = new TreeMap<String, Metric>();
        metrics.getMetrics().forEach((key, value) -> {
            if (filter.matches((String)key, (Metric)value)) {
                matchingMetrics.put((String)key, (Metric)value);
            }
        });
        return matchingMetrics;
    }

    @Deprecated
    public static void registerCache(MetricRegistry registry, Cache<?, ?> cache, @Safe String name) {
        MetricRegistries.registerCache(registry, cache, name, Clock.defaultClock());
    }

    @VisibleForTesting
    static void registerCache(MetricRegistry registry, Cache<?, ?> cache, @Safe String name, Clock clock) {
        Preconditions.checkNotNull(registry, "metric registry");
        Preconditions.checkNotNull(cache, "cache");
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(clock, "clock");
        Preconditions.checkArgument(!name.trim().isEmpty(), "Cache name cannot be blank or empty");
        CacheMetricSet.create(cache, name).getMetrics().forEach((key, value) -> MetricRegistries.registerWithReplacement(registry, key, value));
    }

    @Deprecated
    public static void registerCache(TaggedMetricRegistry registry, Cache<?, ?> cache, @Safe String name) {
        Preconditions.checkNotNull(registry, "metric registry");
        Preconditions.checkNotNull(cache, "cache");
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkArgument(!name.trim().isEmpty(), "Cache name cannot be blank or empty");
        CacheTaggedMetrics.create(cache, name).getMetrics().forEach(registry::registerWithReplacement);
    }

    public static void registerGarbageCollection(TaggedMetricRegistry registry) {
        GarbageCollectorMetrics.register(Preconditions.checkNotNull(registry, "TaggedMetricRegistry is required"));
    }

    public static void registerMemoryPools(TaggedMetricRegistry registry) {
        MemoryPoolMetrics.register(Preconditions.checkNotNull(registry, "TaggedMetricRegistry is required"));
    }

    public static ScheduledExecutorService instrument(TaggedMetricRegistry registry, ScheduledExecutorService delegate, @Safe String name) {
        return new TaggedMetricsScheduledExecutorService(Preconditions.checkNotNull(delegate, "delegate"), ExecutorMetrics.of(registry), Preconditions.checkNotNull(name, "name"));
    }

    public static ExecutorService instrument(TaggedMetricRegistry registry, ExecutorService delegate, @Safe String name) {
        return MetricRegistries.executor().registry(registry).name(name).executor(delegate).build();
    }

    public static ThreadFactory instrument(TaggedMetricRegistry registry, ThreadFactory delegate, @Safe String name) {
        return new TaggedMetricsThreadFactory(Preconditions.checkNotNull(delegate, "ThreadFactory is required"), ExecutorMetrics.of(registry), Preconditions.checkNotNull(name, "Name is required"));
    }

    public static SSLContext instrument(TaggedMetricRegistry registry, SSLContext context, @Safe String name) {
        return new InstrumentedSslContext(Preconditions.checkNotNull(context, "context"), TlsMetrics.of(registry), Preconditions.checkNotNull(name, "name"));
    }

    public static SSLSocketFactory instrument(TaggedMetricRegistry registry, SSLSocketFactory factory, @Safe String name) {
        return new InstrumentedSslSocketFactory(Preconditions.checkNotNull(factory, "factory"), TlsMetrics.of(registry), Preconditions.checkNotNull(name, "name"));
    }

    public static SSLEngine unwrap(SSLEngine engine) {
        return InstrumentedSslEngine.extractDelegate(Preconditions.checkNotNull(engine, "engine"));
    }

    public static <T extends Metric> T registerSafe(MetricRegistry registry, @Safe String name, T metric) {
        return MetricRegistries.registerOrReplace(registry, name, metric, false);
    }

    public static <T extends Metric> T registerWithReplacement(MetricRegistry registry, @Safe String name, T metric) {
        return MetricRegistries.registerOrReplace(registry, name, metric, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Metric> T registerOrReplace(MetricRegistry registry, @Safe String name, T metric, boolean replace) {
        MetricRegistry metricRegistry = registry;
        synchronized (metricRegistry) {
            Map<String, Metric> metrics = registry.getMetrics();
            Metric existingMetric = metrics.get(name);
            if (existingMetric == null) {
                return registry.register(name, metric);
            }
            Set existingMetricInterfaces = Collections.newSetFromMap(new IdentityHashMap());
            existingMetricInterfaces.addAll(Arrays.asList(existingMetric.getClass().getInterfaces()));
            Set newMetricInterfaces = Collections.newSetFromMap(new IdentityHashMap());
            newMetricInterfaces.addAll(Arrays.asList(metric.getClass().getInterfaces()));
            if (!existingMetricInterfaces.equals(newMetricInterfaces)) {
                throw new SafeIllegalArgumentException("Metric already registered at this name that implements a different set of interfaces", SafeArg.of("name", name), SafeArg.of("existingMetric", String.valueOf(existingMetric)));
            }
            if (replace && registry.remove(name)) {
                log.info("Removed existing registered metric with name {}: {}", SafeArg.of("name", name), SafeArg.of("existingMetric", String.valueOf(existingMetric)));
                registry.register(name, metric);
                return metric;
            }
            log.warn("Metric already registered at this name. Name: {}, existing metric: {}", SafeArg.of("name", name), SafeArg.of("existingMetric", String.valueOf(existingMetric)));
            Metric registeredMetric = existingMetric;
            return (T)registeredMetric;
        }
    }

    public static void registerAll(TaggedMetricRegistry registry, @Safe String prefix, MetricSet metricSet) {
        Preconditions.checkNotNull(registry, "TaggedMetricRegistry is required");
        Preconditions.checkNotNull(prefix, "Prefix is required");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(prefix), "Prefix cannot be blank");
        Preconditions.checkNotNull(metricSet, "MetricSet is required");
        metricSet.getMetrics().forEach((name, metric) -> {
            String safeName = MetricRegistry.name(prefix, name);
            MetricName metricName = MetricName.builder().safeName(safeName).build();
            if (metric instanceof Gauge) {
                registry.registerWithReplacement(metricName, (Gauge)metric);
            } else if (metric instanceof Counter) {
                registry.counter(metricName, () -> (Counter)metric);
            } else if (metric instanceof Histogram) {
                registry.histogram(metricName, () -> (Histogram)metric);
            } else if (metric instanceof Meter) {
                registry.meter(metricName, () -> (Meter)metric);
            } else if (metric instanceof Timer) {
                registry.timer(metricName, () -> (Timer)metric);
            } else if (metric instanceof MetricSet) {
                MetricRegistries.registerAll(registry, safeName, (MetricSet)metric);
            } else {
                throw new SafeIllegalArgumentException("Unknown Metric Type", SafeArg.of("type", metric.getClass()));
            }
        });
    }

    @CheckReturnValue
    public static ExecutorInstrumentationBuilderRegistryStage executor() {
        return new ExecutorInstrumentationBuilder();
    }

    public static interface ExecutorInstrumentationBuilderFinalStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage reportQueuedDuration(boolean var1);

        @CheckReturnValue
        public ExecutorService build();
    }

    public static interface ExecutorInstrumentationBuilderExecutorStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage executor(ExecutorService var1);
    }

    public static interface ExecutorInstrumentationBuilderNameStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderExecutorStage name(@Safe String var1);
    }

    public static interface ExecutorInstrumentationBuilderRegistryStage {
        @CheckReturnValue
        public ExecutorInstrumentationBuilderNameStage registry(TaggedMetricRegistry var1);
    }

    private static final class ExecutorInstrumentationBuilder
    implements ExecutorInstrumentationBuilderRegistryStage,
    ExecutorInstrumentationBuilderNameStage,
    ExecutorInstrumentationBuilderExecutorStage,
    ExecutorInstrumentationBuilderFinalStage {
        @Nullable
        private TaggedMetricRegistry registry;
        @Safe
        @Nullable
        private String name;
        @Nullable
        private ExecutorService executor;
        private boolean reportQueuedDuration = true;

        private ExecutorInstrumentationBuilder() {
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderNameStage registry(TaggedMetricRegistry value) {
            this.registry = Preconditions.checkNotNull(value, "TaggedMetricRegistry");
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderExecutorStage name(@Safe String value) {
            this.name = Preconditions.checkNotNull(value, "Name");
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage executor(ExecutorService value) {
            this.executor = Preconditions.checkNotNull(value, "ExecutorService");
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorInstrumentationBuilderFinalStage reportQueuedDuration(boolean value) {
            this.reportQueuedDuration = value;
            return this;
        }

        @Override
        @CheckReturnValue
        public ExecutorService build() {
            if (this.executor instanceof ScheduledExecutorService) {
                return MetricRegistries.instrument(Preconditions.checkNotNull(this.registry, "delegate"), (ScheduledExecutorService)this.executor, Preconditions.checkNotNull(this.name, "Name"));
            }
            return new TaggedMetricsExecutorService(Preconditions.checkNotNull(this.executor, "delegate"), ExecutorMetrics.of(Preconditions.checkNotNull(this.registry, "registry")), Preconditions.checkNotNull(this.name, "name"), this.reportQueuedDuration);
        }
    }
}

