/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import java.util.function.Supplier;
import shadow.palantir.driver.com.codahale.metrics.Histogram;
import shadow.palantir.driver.com.codahale.metrics.MetricRegistry;
import shadow.palantir.driver.com.codahale.metrics.Reservoir;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.palantir.tritium.metrics.HistogramMetricBuilder;
import shadow.palantir.driver.com.palantir.tritium.metrics.MetricRegistries;
import shadow.palantir.driver.com.palantir.tritium.metrics.TimerMetricBuilder;

final class MetricRegistryWithReservoirs
extends MetricRegistry {
    private final HistogramMetricBuilder histogramMetricBuilder;
    private final TimerMetricBuilder timerMetricBuilder;

    MetricRegistryWithReservoirs(Supplier<Reservoir> reservoirSupplier) {
        Preconditions.checkNotNull(reservoirSupplier, "reservoirSupplier");
        this.histogramMetricBuilder = new HistogramMetricBuilder(reservoirSupplier);
        this.timerMetricBuilder = new TimerMetricBuilder(reservoirSupplier);
    }

    @Override
    public Histogram histogram(String name) {
        return MetricRegistries.getOrAdd(this, name, this.histogramMetricBuilder);
    }

    @Override
    public Timer timer(String name) {
        return MetricRegistries.getOrAdd(this, name, this.timerMetricBuilder);
    }
}

