/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import java.util.concurrent.TimeUnit;
import shadow.palantir.driver.com.codahale.metrics.Clock;
import shadow.palantir.driver.com.codahale.metrics.Reservoir;
import shadow.palantir.driver.com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.org.HdrHistogram.Recorder;
import shadow.palantir.driver.org.mpierce.metrics.reservoir.hdrhistogram.HdrHistogramReservoir;

final class Reservoirs {
    private Reservoirs() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    static Reservoir hdrHistogramReservoir() {
        return Reservoirs.hdrHistogramReservoir(new Recorder(2));
    }

    @Nonnull
    private static Reservoir hdrHistogramReservoir(Recorder recorder) {
        Preconditions.checkNotNull(recorder, "recorder");
        return new HdrHistogramReservoir(recorder);
    }

    @Nonnull
    static Reservoir slidingTimeWindowArrayReservoir(long window, TimeUnit windowUnit) {
        return Reservoirs.slidingTimeWindowArrayReservoir(window, windowUnit, Clock.defaultClock());
    }

    @Nonnull
    @VisibleForTesting
    static Reservoir slidingTimeWindowArrayReservoir(long window, TimeUnit windowUnit, Clock clock) {
        Preconditions.checkState(window > 0L, "window must be positive");
        Preconditions.checkNotNull(windowUnit, "windowUnit");
        Preconditions.checkNotNull(clock, "clock");
        return new SlidingTimeWindowArrayReservoir(window, windowUnit, clock);
    }
}

