/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import java.util.concurrent.ThreadFactory;
import shadow.palantir.driver.com.codahale.metrics.Counter;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.palantir.nylon.threads.VirtualThreads;
import shadow.palantir.driver.com.palantir.tritium.metrics.ExecutorMetrics;

final class TaggedMetricsThreadFactory
implements ThreadFactory {
    private final ThreadFactory delegate;
    private final Meter createdPlatform;
    private final Meter createdVirtual;
    private final Counter runningPlatform;
    private final Counter runningVirtual;

    TaggedMetricsThreadFactory(ThreadFactory delegate, ExecutorMetrics metrics, @Safe String name) {
        this.delegate = Preconditions.checkNotNull(delegate, "ThreadFactory is required");
        Preconditions.checkNotNull(name, "Name is required");
        Preconditions.checkNotNull(metrics, "ExecutorMetrics is required");
        this.createdPlatform = metrics.threadsCreated().executor(name).threadType(ExecutorMetrics.ThreadsCreated_ThreadType.PLATFORM).build();
        this.createdVirtual = metrics.threadsCreated().executor(name).threadType(ExecutorMetrics.ThreadsCreated_ThreadType.VIRTUAL).build();
        this.runningPlatform = metrics.threadsRunning().executor(name).threadType(ExecutorMetrics.ThreadsRunning_ThreadType.PLATFORM).build();
        this.runningVirtual = metrics.threadsRunning().executor(name).threadType(ExecutorMetrics.ThreadsRunning_ThreadType.VIRTUAL).build();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread result = this.delegate.newThread(new InstrumentedTask(Preconditions.checkNotNull(runnable, "Runnable is required")));
        this.createdMeterFor(result).mark();
        return result;
    }

    private Meter createdMeterFor(Thread thread) {
        return VirtualThreads.isVirtual(thread) ? this.createdVirtual : this.createdPlatform;
    }

    public String toString() {
        return "TaggedMetricsThreadFactory{delegate=" + this.delegate + "}";
    }

    private final class InstrumentedTask
    implements Runnable {
        private final Runnable delegate;

        InstrumentedTask(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            Counter running = this.runningCounterFor(Thread.currentThread());
            running.inc();
            try {
                this.delegate.run();
            }
            finally {
                running.dec();
            }
        }

        private Counter runningCounterFor(Thread thread) {
            return VirtualThreads.isVirtual(thread) ? TaggedMetricsThreadFactory.this.runningVirtual : TaggedMetricsThreadFactory.this.runningPlatform;
        }

        public String toString() {
            return "InstrumentedTask{delegate=" + this.delegate + "}";
        }
    }
}

