/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.google.errorprone.annotations.CheckReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class TlsMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.93.0";
    private final TaggedMetricRegistry registry;

    private TlsMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static TlsMetrics of(TaggedMetricRegistry registry) {
        return new TlsMetrics(Preconditions.checkNotNull(registry, "TaggedMetricRegistry"));
    }

    @CheckReturnValue
    HandshakeBuilderContextStage handshake() {
        return new HandshakeBuilder();
    }

    public String toString() {
        return "TlsMetrics{registry=" + this.registry + "}";
    }

    private final class HandshakeBuilder
    implements HandshakeBuilderContextStage,
    HandshakeBuilderCipherStage,
    HandshakeBuilderProtocolStage,
    HandshakeBuildStage {
        private String context;
        private String cipher;
        private String protocol;

        private HandshakeBuilder() {
        }

        @Override
        public HandshakeBuilder context(@Safe String context) {
            Preconditions.checkState(this.context == null, "context is already set");
            this.context = Preconditions.checkNotNull(context, "context is required");
            return this;
        }

        @Override
        public HandshakeBuilder cipher(@Safe String cipher) {
            Preconditions.checkState(this.cipher == null, "cipher is already set");
            this.cipher = Preconditions.checkNotNull(cipher, "cipher is required");
            return this;
        }

        @Override
        public HandshakeBuilder protocol(@Safe String protocol) {
            Preconditions.checkState(this.protocol == null, "protocol is already set");
            this.protocol = Preconditions.checkNotNull(protocol, "protocol is required");
            return this;
        }

        @Override
        public Meter build() {
            return TlsMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("tls.handshake").putSafeTags("context", this.context).putSafeTags("cipher", this.cipher).putSafeTags("protocol", this.protocol).putSafeTags("libraryName", TlsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", TlsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface HandshakeBuilderProtocolStage {
        @CheckReturnValue
        public HandshakeBuildStage protocol(@Safe String var1);
    }

    static interface HandshakeBuilderCipherStage {
        @CheckReturnValue
        public HandshakeBuilderProtocolStage cipher(@Safe String var1);
    }

    static interface HandshakeBuilderContextStage {
        @CheckReturnValue
        public HandshakeBuilderCipherStage context(@Safe String var1);
    }

    static interface HandshakeBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

