/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics.registry;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.palantir.driver.com.codahale.metrics.Counter;
import shadow.palantir.driver.com.codahale.metrics.Gauge;
import shadow.palantir.driver.com.codahale.metrics.Histogram;
import shadow.palantir.driver.com.codahale.metrics.Meter;
import shadow.palantir.driver.com.codahale.metrics.Metric;
import shadow.palantir.driver.com.codahale.metrics.Reservoir;
import shadow.palantir.driver.com.codahale.metrics.Timer;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.collect.Maps;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.RealMetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricSet;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

public abstract class AbstractTaggedMetricRegistry
implements TaggedMetricRegistry {
    private static final Supplier<Logger> log = Suppliers.memoize(() -> LoggerFactory.getLogger(AbstractTaggedMetricRegistry.class));
    private final Map<MetricName, Metric> registry = new ConcurrentHashMap<MetricName, Metric>();
    private final Map<Map.Entry<String, String>, TaggedMetricSet> taggedRegistries = new ConcurrentHashMap<Map.Entry<String, String>, TaggedMetricSet>();
    private final Supplier<Reservoir> reservoirSupplier;

    public AbstractTaggedMetricRegistry(Supplier<Reservoir> reservoirSupplier) {
        this.reservoirSupplier = Preconditions.checkNotNull(reservoirSupplier, "reservoirSupplier");
    }

    @Nonnull
    protected Supplier<Counter> counterSupplier() {
        return Counter::new;
    }

    @Nonnull
    protected Supplier<Histogram> histogramSupplier() {
        return () -> new Histogram(this.createReservoir());
    }

    @Nonnull
    protected Supplier<Meter> meterSupplier() {
        return Meter::new;
    }

    @Nonnull
    protected Supplier<Timer> timerSupplier() {
        return () -> new Timer(this.createReservoir());
    }

    @Nonnull
    protected final Reservoir createReservoir() {
        return this.reservoirSupplier.get();
    }

    @Override
    public final Counter counter(MetricName metricName) {
        return this.counter(metricName, this.counterSupplier());
    }

    @Override
    public final Counter counter(MetricName metricName, Supplier<Counter> counterSupplier) {
        return this.getOrAdd(metricName, Counter.class, counterSupplier);
    }

    @Override
    public final <T> Optional<Gauge<T>> gauge(MetricName metricName) {
        return Optional.ofNullable(AbstractTaggedMetricRegistry.checkMetricType(metricName, Gauge.class, this.registry.get(metricName)));
    }

    @Override
    public final <T> Gauge<T> gauge(MetricName metricName, Gauge<T> gauge) {
        return this.getOrAdd(metricName, Gauge.class, () -> gauge);
    }

    @Override
    public final void registerWithReplacement(MetricName metricName, Gauge<?> gauge) {
        Metric existing = this.registry.put(metricName, gauge);
        if (existing instanceof Gauge) {
            log.get().debug("Removed previously registered gauge", (Object)SafeArg.of("metricName", metricName));
        } else if (existing != null) {
            this.registry.replace(metricName, existing);
            throw AbstractTaggedMetricRegistry.invalidMetric(metricName, gauge.getClass(), existing);
        }
    }

    @Override
    public final Histogram histogram(MetricName metricName) {
        return this.histogram(metricName, this.histogramSupplier());
    }

    @Override
    public final Histogram histogram(MetricName metricName, Supplier<Histogram> histogramSupplier) {
        return this.getOrAdd(metricName, Histogram.class, histogramSupplier);
    }

    @Override
    public final Meter meter(MetricName metricName) {
        return this.meter(metricName, this.meterSupplier());
    }

    @Override
    public final Meter meter(MetricName metricName, Supplier<Meter> meterSupplier) {
        return this.getOrAdd(metricName, Meter.class, meterSupplier);
    }

    @Override
    public final Timer timer(MetricName metricName) {
        return this.timer(metricName, this.timerSupplier());
    }

    @Override
    public final Timer timer(MetricName metricName, Supplier<Timer> timerSupplier) {
        return this.getOrAdd(metricName, Timer.class, timerSupplier);
    }

    @Override
    public final Map<MetricName, Metric> getMetrics() {
        ImmutableMap.Builder<MetricName, Metric> result = ImmutableMap.builder();
        result.putAll(this.registry);
        this.taggedRegistries.forEach((tag, metrics) -> metrics.getMetrics().forEach((metricName, metric) -> result.put(RealMetricName.create(metricName, (String)tag.getKey(), (String)tag.getValue()), (Metric)metric)));
        return result.buildKeepingLast();
    }

    @Override
    public final void forEachMetric(BiConsumer<MetricName, Metric> consumer) {
        this.registry.forEach(consumer);
        this.taggedRegistries.forEach((tag, metrics) -> metrics.forEachMetric((metricName, metric) -> consumer.accept(RealMetricName.create(metricName, (String)tag.getKey(), (String)tag.getValue()), (Metric)metric)));
    }

    @Override
    public final Optional<Metric> remove(MetricName metricName) {
        return Optional.ofNullable(this.registry.remove(metricName));
    }

    @Override
    public final void addMetrics(String safeTagName, String safeTagValue, TaggedMetricSet other) {
        this.taggedRegistries.put(Maps.immutableEntry(safeTagName, safeTagValue), other);
    }

    @Override
    public final Optional<TaggedMetricSet> removeMetrics(String safeTagName, String safeTagValue) {
        return Optional.ofNullable(this.taggedRegistries.remove(Maps.immutableEntry(safeTagName, safeTagValue)));
    }

    @Override
    public final boolean removeMetrics(String safeTagName, String safeTagValue, TaggedMetricSet metrics) {
        return this.taggedRegistries.remove(Maps.immutableEntry(safeTagName, safeTagValue), metrics);
    }

    protected final <T extends Metric> T getOrAdd(MetricName metricName, Class<T> metricClass, Supplier<T> metricSupplier) {
        Metric metric = this.registry.computeIfAbsent(metricName, _name -> (Metric)metricSupplier.get());
        return (T)((Metric)Preconditions.checkNotNull(AbstractTaggedMetricRegistry.checkMetricType(metricName, metricClass, metric), "metric"));
    }

    @Nullable
    static <T extends Metric> T checkMetricType(MetricName metricName, Class<T> metricClass, @Nullable Metric metric) {
        if (metric == null || metricClass.isInstance(metric)) {
            return (T)((Metric)metricClass.cast(metric));
        }
        throw AbstractTaggedMetricRegistry.invalidMetric(metricName, metricClass, metric);
    }

    private static <T extends Metric> SafeIllegalArgumentException invalidMetric(MetricName metricName, Class<T> metricClass, Metric metric) {
        return new SafeIllegalArgumentException("Metric name already used for different metric type", SafeArg.of("metricName", metricName.safeName()), SafeArg.of("existingMetricType", metric.getClass().getSimpleName()), SafeArg.of("newMetricType", metricClass.getSimpleName()), SafeArg.of("safeTags", metricName.safeTags()));
    }
}

