/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics.registry;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import java.util.Map;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.RealMetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TagMap;
import shadow.palantir.driver.javax.annotation.Nullable;

final class ImmutableMetricName {
    private ImmutableMetricName() {
    }

    public static abstract class Builder {
        @Nullable
        private String safeName;
        private TagMap tagMap = TagMap.EMPTY;

        @CanIgnoreReturnValue
        public MetricName.Builder from(MetricName instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.safeName(instance.safeName());
            this.putAllSafeTags(instance.safeTags());
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder safeName(@Safe String value) {
            this.safeName = Preconditions.checkNotNull(value, "safeName");
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder putSafeTags(@Safe String key, @Safe String value) {
            Preconditions.checkNotNull(key, "safeTagName");
            Preconditions.checkNotNull(value, "safeTagValue");
            this.tagMap = this.tagMap.withEntry(key, value);
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder putSafeTags(@Safe @Safe Map.Entry<@Safe String, @Safe ? extends String> entry) {
            Preconditions.checkNotNull(entry, "entry");
            this.tagMap = this.tagMap.withEntry(entry.getKey(), entry.getValue());
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder safeTags(@Safe @Safe Map<@Safe String, @Safe ? extends String> entries) {
            Preconditions.checkNotNull(entries, "entries");
            this.tagMap = TagMap.of(entries);
            return (MetricName.Builder)this;
        }

        @CanIgnoreReturnValue
        public MetricName.Builder putAllSafeTags(@Safe @Safe Map<@Safe String, @Safe ? extends String> entries) {
            Preconditions.checkNotNull(entries, "entries");
            if (!entries.isEmpty()) {
                this.tagMap = this.tagMap.isEmpty() ? TagMap.of(entries) : TagMap.of(ImmutableMap.builderWithExpectedSize(this.tagMap.size() + entries.size()).putAll(this.tagMap).putAll(entries).buildKeepingLast());
            }
            return (MetricName.Builder)this;
        }

        public MetricName build() {
            return new RealMetricName(this.safeName, this.tagMap);
        }
    }
}

