/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.tritium.metrics.registry;

import com.palantir.logsafe.Preconditions;
import java.util.SortedMap;
import shadow.palantir.driver.com.google.common.collect.ImmutableSortedMap;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.MetricName;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TagMap;
import shadow.palantir.driver.javax.annotation.Nullable;

final class RealMetricName
implements MetricName {
    private final String safeName;
    private final TagMap safeTags;
    private int hashCode;

    RealMetricName(String safeName, TagMap safeTags) {
        this.safeName = Preconditions.checkNotNull(safeName, "safeName is required");
        this.safeTags = Preconditions.checkNotNull(safeTags, "safeTags is required");
    }

    private int computeHashCode() {
        int hash = 5381;
        hash += (hash << 5) + this.safeName().hashCode();
        hash += (hash << 5) + this.safeTags().hashCode();
        return hash;
    }

    @Override
    public String safeName() {
        return this.safeName;
    }

    public TagMap safeTags() {
        return this.safeTags;
    }

    public String toString() {
        return "MetricName{safeName=" + this.safeName + ", safeTags=" + this.safeTags + "}";
    }

    public int hashCode() {
        int memoized = this.hashCode;
        if (memoized == 0) {
            this.hashCode = memoized = this.computeHashCode();
        }
        return memoized;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof MetricName)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        MetricName otherMetric = (MetricName)other;
        return this.safeName().equals(otherMetric.safeName()) && this.safeTags().equals(otherMetric.safeTags());
    }

    static MetricName create(String safeName) {
        return new RealMetricName(safeName, TagMap.EMPTY);
    }

    static MetricName create(MetricName other) {
        return new RealMetricName(other.safeName(), TagMap.of(other.safeTags()));
    }

    static MetricName create(MetricName other, String extraTagName, String extraTagValue) {
        return new RealMetricName(other.safeName(), RealMetricName.withEntry(other.safeTags(), extraTagName, extraTagValue));
    }

    private static TagMap withEntry(SortedMap<String, String> tags, String extraTagName, String extraTagValue) {
        if (tags instanceof TagMap) {
            return ((TagMap)tags).withEntry(extraTagName, extraTagValue);
        }
        return RealMetricName.withEntryFallback(tags, extraTagName, extraTagValue);
    }

    private static TagMap withEntryFallback(SortedMap<String, String> tags, String extraTagName, String extraTagValue) {
        return TagMap.of(((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)ImmutableSortedMap.naturalOrder().putAll(tags)).put(extraTagName, extraTagValue)).buildOrThrow());
    }
}

