/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.io.netty.buffer;

import java.nio.ByteBuffer;
import shadow.palantir.driver.io.netty.buffer.ByteBuf;
import shadow.palantir.driver.io.netty.buffer.ByteBufAllocator;
import shadow.palantir.driver.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import shadow.palantir.driver.io.netty.util.internal.CleanableDirectBuffer;
import shadow.palantir.driver.io.netty.util.internal.PlatformDependent;

class UnpooledUnsafeNoCleanerDirectByteBuf
extends UnpooledUnsafeDirectByteBuf {
    UnpooledUnsafeNoCleanerDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity, boolean allowSectionedInternalNioBufferAccess) {
        super(alloc, initialCapacity, maxCapacity, allowSectionedInternalNioBufferAccess);
    }

    @Override
    protected CleanableDirectBuffer allocateDirectBuffer(int capacity) {
        return PlatformDependent.allocateDirectBufferNoCleaner(capacity);
    }

    @Override
    protected ByteBuffer allocateDirect(int initialCapacity) {
        throw new UnsupportedOperationException();
    }

    CleanableDirectBuffer reallocateDirect(CleanableDirectBuffer oldBuffer, int initialCapacity) {
        return PlatformDependent.reallocateDirectBufferNoCleaner(oldBuffer, initialCapacity);
    }

    @Override
    protected void freeDirect(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        int oldCapacity = this.capacity();
        if (newCapacity == oldCapacity) {
            return this;
        }
        this.trimIndicesToCapacity(newCapacity);
        this.setByteBuffer(this.reallocateDirect(this.cleanable, newCapacity), false);
        return this;
    }
}

