/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.one.util.streamex;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import shadow.palantir.driver.one.util.streamex.Internals;
import shadow.palantir.driver.one.util.streamex.StreamContext;
import shadow.palantir.driver.one.util.streamex.StreamEx;

final class HeadTailSpliterator<T, U>
extends Spliterators.AbstractSpliterator<U>
implements Internals.TailSpliterator<U> {
    private Spliterator<T> source;
    private BiFunction<? super T, ? super StreamEx<T>, ? extends Stream<U>> mapper;
    private Supplier<? extends Stream<U>> emptyMapper;
    private Spliterator<U> target;
    StreamContext context;

    HeadTailSpliterator(Spliterator<T> source, BiFunction<? super T, ? super StreamEx<T>, ? extends Stream<U>> mapper, Supplier<? extends Stream<U>> emptyMapper) {
        super(Long.MAX_VALUE, 16);
        this.source = source;
        this.mapper = mapper;
        this.emptyMapper = emptyMapper;
    }

    @Override
    public boolean tryAdvance(Consumer<? super U> action) {
        if (!this.init()) {
            return false;
        }
        this.target = Internals.TailSpliterator.tryAdvanceWithTail(this.target, action);
        if (this.target == null) {
            this.context = null;
            return false;
        }
        return true;
    }

    @Override
    public Spliterator<U> tryAdvanceOrTail(Consumer<? super U> action) {
        if (!this.init()) {
            return null;
        }
        Spliterator<U> tail = this.target;
        this.target = null;
        this.context = null;
        return tail;
    }

    @Override
    public void forEachRemaining(Consumer<? super U> action) {
        if (!this.init()) {
            return;
        }
        Internals.TailSpliterator.forEachWithTail(this.target, action);
        this.target = null;
        this.context = null;
    }

    @Override
    public Spliterator<U> forEachOrTail(Consumer<? super U> action) {
        return this.tryAdvanceOrTail(action);
    }

    private boolean init() {
        if (this.context == null) {
            return false;
        }
        if (this.target == null) {
            Internals.Box first = new Internals.Box();
            this.source = Internals.TailSpliterator.tryAdvanceWithTail(this.source, first);
            Stream<U> stream = this.source == null ? this.emptyMapper.get() : this.mapper.apply(first.a, StreamEx.of(this.source));
            this.source = null;
            this.mapper = null;
            this.emptyMapper = null;
            if (stream == null) {
                this.target = Spliterators.emptySpliterator();
            } else {
                StreamContext ctx = StreamContext.of(stream);
                if (ctx.closeHandler != null) {
                    this.context.onClose(ctx.closeHandler);
                }
                this.target = stream.spliterator();
            }
        }
        return true;
    }

    @Override
    public long estimateSize() {
        if (this.context == null) {
            return 0L;
        }
        return (this.target == null ? this.source : this.target).estimateSize();
    }
}

