/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.one.util.streamex;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import shadow.palantir.driver.one.util.streamex.Internals;

abstract class PrefixOps<T, S extends Spliterator<T>>
extends Internals.CloneableSpliterator<T, PrefixOps<T, S>> {
    private static final int BUF_SIZE = 128;
    S source;
    int idx = 0;

    PrefixOps(S source) {
        this.source = source;
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0x5450;
    }

    static final class OfUnordLong
    extends PrefixOps<Long, Spliterator.OfLong>
    implements LongConsumer,
    Spliterator.OfLong {
        private final LongBinaryOperator op;
        private boolean started;
        private MyAtomicLong accRef;
        private long acc;
        private LongPrefixBuffer buffer;

        OfUnordLong(Spliterator.OfLong source, LongBinaryOperator op) {
            super(source);
            this.op = op;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            if (this.started) {
                return null;
            }
            Spliterator.OfLong prefix = ((Spliterator.OfLong)this.source).trySplit();
            if (prefix == null) {
                return null;
            }
            if (this.accRef == null) {
                this.accRef = new MyAtomicLong();
                this.buffer = new LongPrefixBuffer();
            }
            OfUnordLong pref = (OfUnordLong)this.doClone();
            pref.source = prefix;
            pref.buffer = new LongPrefixBuffer();
            return pref;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (this.accRef == null) {
                if (!((Spliterator.OfLong)this.source).tryAdvance(this)) {
                    return false;
                }
                action.accept(this.acc);
            } else {
                if (!this.buffer.init((Spliterator.OfLong)this.source)) {
                    return false;
                }
                this.buffer.drainOne(action);
            }
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            if (this.accRef == null) {
                ((Spliterator.OfLong)this.source).forEachRemaining((long next) -> {
                    if (this.started) {
                        this.acc = this.op.applyAsLong(this.acc, next);
                    } else {
                        this.acc = next;
                        this.started = true;
                    }
                    action.accept(this.acc);
                });
            } else {
                this.buffer.drainAll(action);
                long[] buf = new long[128];
                ((Spliterator.OfLong)this.source).forEachRemaining((long next) -> {
                    if (this.idx == 0) {
                        buf[this.idx++] = next;
                    } else {
                        long prev = buf[this.idx - 1];
                        buf[this.idx++] = this.op.applyAsLong(prev, next);
                        if (this.idx == buf.length) {
                            this.drain(action, buf);
                            this.idx = 0;
                        }
                    }
                });
                if (this.idx > 0) {
                    this.drain(action, buf);
                }
            }
        }

        private void drain(LongConsumer action, long[] buf) {
            long last = buf[this.idx - 1];
            boolean accRefJustInitialized = this.accRef.initialize(last);
            if (accRefJustInitialized) {
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(buf[i]);
                }
            } else {
                long acc2 = this.accRef.getAndAccumulate(last, this.op);
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(this.op.applyAsLong(buf[i], acc2));
                }
            }
        }

        @Override
        public void accept(long next) {
            if (this.started) {
                this.acc = this.op.applyAsLong(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }

        private static final class MyAtomicLong
        extends AtomicLong {
            private boolean init;

            private MyAtomicLong() {
            }

            public synchronized boolean initialize(long x) {
                if (!this.init) {
                    this.init = true;
                    this.set(x);
                    return true;
                }
                return false;
            }
        }

        private final class LongPrefixBuffer
        extends PrefixBuffer
        implements LongConsumer {
            private final long[] buf = new long[128];
            private long prevBufferLast;

            private LongPrefixBuffer() {
            }

            boolean init(Spliterator.OfLong source) {
                if (this.idx == 0) {
                    for (int i = 0; i < 128 && source.tryAdvance(this); ++i) {
                    }
                    if (this.idx == 0) {
                        return false;
                    }
                    long last = this.buf[this.idx - 1];
                    boolean bl = this.isFirst = this.isFirst || OfUnordLong.this.accRef.initialize(last);
                    if (!this.isFirst) {
                        this.prevBufferLast = OfUnordLong.this.accRef.getAndAccumulate(last, OfUnordLong.this.op);
                    }
                }
                return true;
            }

            void drainOne(LongConsumer action) {
                long value = this.buf[--this.idx];
                if (this.isFirst) {
                    action.accept(value);
                    if (this.idx == 0) {
                        this.isFirst = false;
                    }
                } else {
                    action.accept(OfUnordLong.this.op.applyAsLong(value, this.prevBufferLast));
                }
            }

            void drainAll(LongConsumer action) {
                if (!this.isInit()) {
                    return;
                }
                if (this.isFirst) {
                    for (int i = 0; i < this.idx; ++i) {
                        action.accept(this.buf[i]);
                    }
                    this.isFirst = false;
                } else {
                    for (int i = 0; i < this.idx; ++i) {
                        action.accept(OfUnordLong.this.op.applyAsLong(this.buf[i], this.prevBufferLast));
                    }
                }
                this.idx = 0;
            }

            @Override
            public void accept(long value) {
                if (this.idx == 0) {
                    this.buf[this.idx++] = value;
                } else {
                    long prev = this.buf[this.idx - 1];
                    this.buf[this.idx++] = OfUnordLong.this.op.applyAsLong(prev, value);
                }
            }
        }
    }

    static final class OfUnordInt
    extends PrefixOps<Integer, Spliterator.OfInt>
    implements IntConsumer,
    Spliterator.OfInt {
        private final LongBinaryOperator op;
        private final IntBinaryOperator localOp;
        private boolean started;
        private int acc;
        private AtomicLong accRef;
        private IntPrefixBuffer buffer;

        OfUnordInt(Spliterator.OfInt source, IntBinaryOperator op) {
            super(source);
            this.localOp = op;
            this.op = (a, b) -> a == Long.MAX_VALUE ? b : (long)op.applyAsInt((int)a, (int)b);
        }

        @Override
        public Spliterator.OfInt trySplit() {
            if (this.started) {
                return null;
            }
            Spliterator.OfInt prefix = ((Spliterator.OfInt)this.source).trySplit();
            if (prefix == null) {
                return null;
            }
            if (this.accRef == null) {
                this.accRef = new AtomicLong(Long.MAX_VALUE);
                this.buffer = new IntPrefixBuffer();
            }
            OfUnordInt pref = (OfUnordInt)this.doClone();
            pref.source = prefix;
            pref.buffer = new IntPrefixBuffer();
            return pref;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (this.accRef == null) {
                if (!((Spliterator.OfInt)this.source).tryAdvance(this)) {
                    return false;
                }
                action.accept(this.acc);
            } else {
                if (!this.buffer.init((Spliterator.OfInt)this.source)) {
                    return false;
                }
                this.buffer.drainOne(action);
            }
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            if (this.accRef == null) {
                ((Spliterator.OfInt)this.source).forEachRemaining((int next) -> {
                    if (this.started) {
                        this.acc = this.localOp.applyAsInt(this.acc, next);
                    } else {
                        this.acc = next;
                        this.started = true;
                    }
                    action.accept(this.acc);
                });
            } else {
                this.buffer.drainAll(action);
                int[] buf = new int[128];
                ((Spliterator.OfInt)this.source).forEachRemaining((int next) -> {
                    if (this.idx == 0) {
                        buf[this.idx++] = next;
                    } else {
                        int prev = buf[this.idx - 1];
                        buf[this.idx++] = this.localOp.applyAsInt(prev, next);
                        if (this.idx == buf.length) {
                            this.drain(action, buf);
                            this.idx = 0;
                        }
                    }
                });
                if (this.idx > 0) {
                    this.drain(action, buf);
                }
            }
        }

        private void drain(IntConsumer action, int[] buf) {
            int last = buf[this.idx - 1];
            if (this.accRef.compareAndSet(Long.MAX_VALUE, last)) {
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(buf[i]);
                }
            } else {
                int acc2 = (int)this.accRef.getAndAccumulate(last, this.op);
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(this.localOp.applyAsInt(buf[i], acc2));
                }
            }
        }

        @Override
        public void accept(int next) {
            if (this.started) {
                this.acc = this.localOp.applyAsInt(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }

        private final class IntPrefixBuffer
        extends PrefixBuffer
        implements IntConsumer {
            private final int[] buf = new int[128];
            private int prevBufferLast;

            private IntPrefixBuffer() {
            }

            boolean init(Spliterator.OfInt source) {
                if (this.idx == 0) {
                    for (int i = 0; i < 128 && source.tryAdvance(this); ++i) {
                    }
                    if (this.idx == 0) {
                        return false;
                    }
                    int last = this.buf[this.idx - 1];
                    boolean bl = this.isFirst = this.isFirst || OfUnordInt.this.accRef.compareAndSet(Long.MAX_VALUE, last);
                    if (!this.isFirst) {
                        this.prevBufferLast = (int)OfUnordInt.this.accRef.getAndAccumulate(last, OfUnordInt.this.op);
                    }
                }
                return true;
            }

            void drainOne(IntConsumer action) {
                int value = this.buf[--this.idx];
                if (this.isFirst) {
                    action.accept(value);
                    if (this.idx == 0) {
                        this.isFirst = false;
                    }
                } else {
                    action.accept(OfUnordInt.this.localOp.applyAsInt(value, this.prevBufferLast));
                }
            }

            void drainAll(IntConsumer action) {
                if (!this.isInit()) {
                    return;
                }
                if (this.isFirst) {
                    for (int i = 0; i < this.idx; ++i) {
                        action.accept(this.buf[i]);
                    }
                    this.isFirst = false;
                } else {
                    for (int i = 0; i < this.idx; ++i) {
                        action.accept(OfUnordInt.this.localOp.applyAsInt(this.buf[i], this.prevBufferLast));
                    }
                }
                this.idx = 0;
            }

            @Override
            public void accept(int value) {
                if (this.idx == 0) {
                    this.buf[this.idx++] = value;
                } else {
                    int prev = this.buf[this.idx - 1];
                    this.buf[this.idx++] = OfUnordInt.this.localOp.applyAsInt(prev, value);
                }
            }
        }
    }

    static final class OfUnordRef<T>
    extends PrefixOps<T, Spliterator<T>>
    implements Consumer<T> {
        private final BinaryOperator<T> localOp;
        private AtomicReference<T> accRef;
        private T acc = Internals.none();
        private final BinaryOperator<T> op;
        private RefPrefixBuffer buffer;

        OfUnordRef(Spliterator<T> source, BinaryOperator<T> op) {
            super(source);
            this.localOp = op;
            this.op = (a, b) -> a == Internals.NONE ? b : op.apply(a, b);
        }

        @Override
        public Spliterator<T> trySplit() {
            if (this.acc != Internals.NONE) {
                return null;
            }
            Spliterator prefix = this.source.trySplit();
            if (prefix == null) {
                return null;
            }
            if (this.accRef == null) {
                this.accRef = new AtomicReference(Internals.none());
                this.buffer = new RefPrefixBuffer();
            }
            OfUnordRef pref = (OfUnordRef)this.doClone();
            pref.source = prefix;
            pref.buffer = new RefPrefixBuffer();
            return pref;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.accRef == null) {
                if (!this.source.tryAdvance(this)) {
                    return false;
                }
                action.accept(this.acc);
            } else {
                if (!this.buffer.init(this.source)) {
                    return false;
                }
                this.buffer.drainOne(action);
            }
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (this.accRef == null) {
                this.source.forEachRemaining(next -> {
                    this.acc = this.op.apply(this.acc, next);
                    action.accept((T)this.acc);
                });
            } else {
                this.buffer.drainAll(action);
                Object[] buf = new Object[128];
                this.source.forEachRemaining(next -> {
                    if (this.idx == 0) {
                        buf[this.idx++] = next;
                    } else {
                        Object prev = buf[this.idx - 1];
                        buf[this.idx++] = this.localOp.apply(prev, next);
                        if (this.idx == buf.length) {
                            this.drain(action, buf);
                            this.idx = 0;
                        }
                    }
                });
                if (this.idx > 0) {
                    this.drain(action, buf);
                }
            }
        }

        private void drain(Consumer<? super T> action, T[] buf) {
            T last = buf[this.idx - 1];
            T acc2 = this.accRef.getAndAccumulate(last, this.op);
            if (acc2 != Internals.NONE) {
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(this.localOp.apply(buf[i], acc2));
                }
            } else {
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(buf[i]);
                }
            }
        }

        @Override
        public void accept(T next) {
            this.acc = this.op.apply(this.acc, next);
        }

        private final class RefPrefixBuffer
        extends PrefixBuffer
        implements Consumer<T> {
            private final T[] buf = new Object[128];
            private T prevBufferLast;

            private RefPrefixBuffer() {
            }

            boolean init(Spliterator<T> source) {
                if (this.idx == 0) {
                    for (int i = 0; i < 128 && source.tryAdvance(this); ++i) {
                    }
                    if (this.idx == 0) {
                        return false;
                    }
                    Object last = this.buf[this.idx - 1];
                    boolean bl = this.isFirst = this.isFirst || OfUnordRef.this.accRef.compareAndSet(Internals.none(), last);
                    if (!this.isFirst) {
                        this.prevBufferLast = OfUnordRef.this.accRef.getAndAccumulate(last, OfUnordRef.this.op);
                    }
                }
                return true;
            }

            void drainOne(Consumer<? super T> action) {
                Object value = this.buf[--this.idx];
                if (this.isFirst) {
                    action.accept(value);
                    if (this.idx == 0) {
                        this.isFirst = false;
                    }
                } else {
                    action.accept(OfUnordRef.this.localOp.apply(value, this.prevBufferLast));
                }
            }

            void drainAll(Consumer<? super T> action) {
                if (!this.isInit()) {
                    return;
                }
                if (this.isFirst) {
                    for (int i = 0; i < this.idx; ++i) {
                        action.accept(this.buf[i]);
                    }
                    this.isFirst = false;
                } else {
                    for (int i = 0; i < this.idx; ++i) {
                        action.accept(OfUnordRef.this.localOp.apply(this.buf[i], this.prevBufferLast));
                    }
                }
                this.idx = 0;
            }

            @Override
            public void accept(T value) {
                if (this.idx == 0) {
                    this.buf[this.idx++] = value;
                } else {
                    Object prev = this.buf[this.idx - 1];
                    this.buf[this.idx++] = OfUnordRef.this.localOp.apply(prev, value);
                }
            }
        }
    }

    static final class OfDouble
    extends Spliterators.AbstractDoubleSpliterator
    implements DoubleConsumer {
        private final DoubleBinaryOperator op;
        private final Spliterator.OfDouble source;
        private boolean started;
        private double acc;

        OfDouble(Spliterator.OfDouble source, DoubleBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            this.source.forEachRemaining((double next) -> {
                this.accept(next);
                action.accept(this.acc);
            });
        }

        @Override
        public void accept(double next) {
            if (this.started) {
                this.acc = this.op.applyAsDouble(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfLong
    extends Spliterators.AbstractLongSpliterator
    implements LongConsumer {
        private final LongBinaryOperator op;
        private final Spliterator.OfLong source;
        private boolean started;
        private long acc;

        OfLong(Spliterator.OfLong source, LongBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            this.source.forEachRemaining((long next) -> {
                this.accept(next);
                action.accept(this.acc);
            });
        }

        @Override
        public void accept(long next) {
            if (this.started) {
                this.acc = this.op.applyAsLong(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfInt
    extends Spliterators.AbstractIntSpliterator
    implements IntConsumer {
        private final IntBinaryOperator op;
        private final Spliterator.OfInt source;
        private boolean started;
        private int acc;

        OfInt(Spliterator.OfInt source, IntBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            this.source.forEachRemaining((int next) -> {
                this.accept(next);
                action.accept(this.acc);
            });
        }

        @Override
        public void accept(int next) {
            if (this.started) {
                this.acc = this.op.applyAsInt(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfRef<T>
    extends Spliterators.AbstractSpliterator<T>
    implements Consumer<T> {
        private final BinaryOperator<T> op;
        private final Spliterator<T> source;
        private boolean started;
        private T acc;

        OfRef(Spliterator<T> source, BinaryOperator<T> op) {
            super(source.estimateSize(), source.characteristics() & 0x1450);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.source.forEachRemaining(next -> {
                this.accept(next);
                action.accept((T)this.acc);
            });
        }

        @Override
        public void accept(T next) {
            if (this.started) {
                this.acc = this.op.apply(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static abstract class PrefixBuffer {
        protected int idx;
        protected boolean isFirst;

        PrefixBuffer() {
        }

        public boolean isInit() {
            return this.idx != 0;
        }
    }
}

