/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector;

import java.time.Duration;
import shadow.palantir.driver.org.apache.arrow.memory.ArrowBuf;
import shadow.palantir.driver.org.apache.arrow.memory.BufferAllocator;
import shadow.palantir.driver.org.apache.arrow.vector.BaseFixedWidthVector;
import shadow.palantir.driver.org.apache.arrow.vector.BitVectorHelper;
import shadow.palantir.driver.org.apache.arrow.vector.NullCheckingForGet;
import shadow.palantir.driver.org.apache.arrow.vector.ValueIterableVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.DurationReaderImpl;
import shadow.palantir.driver.org.apache.arrow.vector.complex.reader.FieldReader;
import shadow.palantir.driver.org.apache.arrow.vector.holders.DurationHolder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableDurationHolder;
import shadow.palantir.driver.org.apache.arrow.vector.types.TimeUnit;
import shadow.palantir.driver.org.apache.arrow.vector.types.Types;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.ArrowType;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Field;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.FieldType;
import shadow.palantir.driver.org.apache.arrow.vector.util.TransferPair;

public final class DurationVector
extends BaseFixedWidthVector
implements ValueIterableVector<Duration> {
    public static final byte TYPE_WIDTH = 8;
    private final TimeUnit unit;

    public DurationVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public DurationVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 8);
        this.unit = ((ArrowType.Duration)field.getFieldType().getType()).getUnit();
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new DurationReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DURATION;
    }

    public static long get(ArrowBuf buffer, int index) {
        return buffer.getLong((long)index * 8L);
    }

    public ArrowBuf get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.slice((long)index * 8L, 8L);
    }

    public void get(int index, NullableDurationHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = DurationVector.get(this.valueBuffer, index);
        holder.unit = this.unit;
    }

    @Override
    public Duration getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.getObjectNotNull(index);
    }

    public Duration getObjectNotNull(int index) {
        long value = DurationVector.get(this.valueBuffer, index);
        return DurationVector.toDuration(value, this.unit);
    }

    public static Duration toDuration(long value, TimeUnit unit) {
        switch (unit) {
            case SECOND: {
                return Duration.ofSeconds(value);
            }
            case MILLISECOND: {
                return Duration.ofMillis(value);
            }
            case NANOSECOND: {
                return Duration.ofNanos(value);
            }
            case MICROSECOND: {
                return Duration.ofNanos(java.util.concurrent.TimeUnit.MICROSECONDS.toNanos(value));
            }
        }
        throw new IllegalArgumentException("Unknown timeunit: " + String.valueOf((Object)unit));
    }

    public StringBuilder getAsStringBuilder(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.getAsStringBuilderHelper(index);
    }

    private StringBuilder getAsStringBuilderHelper(int index) {
        return new StringBuilder(this.getObject(index).toString());
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void set(int index, ArrowBuf value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.valueBuffer.setBytes((long)index * 8L, value, 0L, 8L);
    }

    public void set(int index, long value) {
        long offsetIndex = (long)index * 8L;
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.valueBuffer.setLong(offsetIndex, value);
    }

    public void set(int index, NullableDurationHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (!this.unit.equals((Object)holder.unit)) {
            throw new IllegalArgumentException(String.format("holder.unit: %s not equal to vector unit: %s", new Object[]{holder.unit, this.unit}));
        }
        if (holder.isSet > 0) {
            this.set(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, DurationHolder holder) {
        if (!this.unit.equals((Object)holder.unit)) {
            throw new IllegalArgumentException(String.format("holder.unit: %s not equal to vector unit: %s", new Object[]{holder.unit, this.unit}));
        }
        this.set(index, holder.value);
    }

    public void setSafe(int index, ArrowBuf value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, long value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableDurationHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, DurationHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, long value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, long value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((DurationVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        DurationVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new DurationVector(ref, DurationVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new DurationVector(field, allocator);
        }

        public TransferImpl(DurationVector to) {
            this.to = to;
        }

        @Override
        public DurationVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            DurationVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            DurationVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, DurationVector.this);
        }
    }
}

