/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.org.apache.arrow.vector;

import java.time.LocalDateTime;
import shadow.palantir.driver.org.apache.arrow.memory.BufferAllocator;
import shadow.palantir.driver.org.apache.arrow.vector.BitVectorHelper;
import shadow.palantir.driver.org.apache.arrow.vector.NullCheckingForGet;
import shadow.palantir.driver.org.apache.arrow.vector.TimeStampVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueIterableVector;
import shadow.palantir.driver.org.apache.arrow.vector.ValueVector;
import shadow.palantir.driver.org.apache.arrow.vector.complex.impl.TimeStampMilliReaderImpl;
import shadow.palantir.driver.org.apache.arrow.vector.complex.reader.FieldReader;
import shadow.palantir.driver.org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import shadow.palantir.driver.org.apache.arrow.vector.holders.TimeStampMilliHolder;
import shadow.palantir.driver.org.apache.arrow.vector.types.Types;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.Field;
import shadow.palantir.driver.org.apache.arrow.vector.types.pojo.FieldType;
import shadow.palantir.driver.org.apache.arrow.vector.util.DateUtility;
import shadow.palantir.driver.org.apache.arrow.vector.util.TransferPair;

public final class TimeStampMilliVector
extends TimeStampVector
implements ValueIterableVector<LocalDateTime> {
    public TimeStampMilliVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMESTAMPMILLI.getType()), allocator);
    }

    public TimeStampMilliVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
    }

    public TimeStampMilliVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new TimeStampMilliReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPMILLI;
    }

    public void get(int index, NullableTimeStampMilliHolder holder) {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong((long)index * 8L);
    }

    @Override
    public LocalDateTime getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        long millis = this.valueBuffer.getLong((long)index * 8L);
        return DateUtility.getLocalDateTimeFromEpochMilli(millis);
    }

    public void set(int index, NullableTimeStampMilliHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeStampMilliHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampMilliHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampMilliHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampMilliVector to = new TimeStampMilliVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        TimeStampMilliVector to = new TimeStampMilliVector(field, allocator);
        return new TimeStampVector.TransferImpl(this, to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl(this, (TimeStampMilliVector)to);
    }
}

